/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.things.Feature;
import org.eclipse.ditto.model.things.FeatureBuilder;
import org.eclipse.ditto.model.things.FeatureDefinition;
import org.eclipse.ditto.model.things.FeatureProperties;
import org.eclipse.ditto.model.things.ThingsModelFactory;

@NotThreadSafe
final class ImmutableFeatureFromScratchBuilder
implements FeatureBuilder,
FeatureBuilder.FromJsonBuildable,
FeatureBuilder.FromScratchBuildable,
FeatureBuilder.FeatureBuildable {
    private String featureId = "emptyFeatureId";
    @Nullable
    private FeatureDefinition definition = null;
    @Nullable
    private FeatureProperties properties = null;
    @Nullable
    private FeatureProperties desiredProperties = null;
    private boolean isFeatureValueJsonNull = false;

    private ImmutableFeatureFromScratchBuilder() {
    }

    public static FeatureBuilder.FromJsonBuildable newFeatureFromJson(JsonObject jsonObject) {
        ConditionChecker.checkNotNull((Object)jsonObject, (String)"Feature JSON object");
        ImmutableFeatureFromScratchBuilder result = new ImmutableFeatureFromScratchBuilder();
        if (jsonObject.isNull()) {
            result.isFeatureValueJsonNull = true;
        } else {
            result.definition(jsonObject.getValue(Feature.JsonFields.DEFINITION).map(ThingsModelFactory::newFeatureDefinition).orElse(null));
            result.properties((FeatureProperties)jsonObject.getValue(Feature.JsonFields.PROPERTIES).map(ThingsModelFactory::newFeatureProperties).orElse(null));
            result.desiredProperties((FeatureProperties)jsonObject.getValue(Feature.JsonFields.DESIRED_PROPERTIES).map(ThingsModelFactory::newFeatureProperties).orElse(null));
        }
        return result;
    }

    public static FeatureBuilder.FromScratchBuildable newFeatureFromScratch() {
        return new ImmutableFeatureFromScratchBuilder();
    }

    @Override
    public FeatureBuilder.FeatureBuildable useId(String featureId) {
        ConditionChecker.checkNotNull((Object)featureId, (String)"Feature ID");
        ConditionChecker.checkArgument((Object)featureId, s -> !s.isEmpty(), () -> "The Feature ID must not be empty!");
        this.featureId = featureId;
        return this;
    }

    @Override
    public FeatureBuilder.FromScratchBuildable definition(@Nullable FeatureDefinition featureDefinition) {
        this.definition = featureDefinition;
        return this;
    }

    @Override
    public FeatureBuilder.FromScratchBuildable properties(@Nullable FeatureProperties properties) {
        this.properties = properties;
        return this;
    }

    @Override
    public FeatureBuilder.FromScratchBuildable properties(@Nullable JsonObject properties) {
        this.properties = null == properties ? null : (properties instanceof FeatureProperties ? (FeatureProperties)properties : ThingsModelFactory.newFeatureProperties(properties));
        return this;
    }

    @Override
    public FeatureBuilder.FromScratchBuildable desiredProperties(@Nullable FeatureProperties desiredProperties) {
        this.desiredProperties = desiredProperties;
        return this;
    }

    @Override
    public FeatureBuilder.FromScratchBuildable desiredProperties(@Nullable JsonObject desiredProperties) {
        this.desiredProperties = null == desiredProperties ? null : (desiredProperties instanceof FeatureProperties ? (FeatureProperties)desiredProperties : ThingsModelFactory.newFeatureProperties(desiredProperties));
        return this;
    }

    @Override
    public FeatureBuilder.FeatureBuildable withId(String featureId) {
        return this.useId(featureId);
    }

    @Override
    public Feature build() {
        if (this.isFeatureValueJsonNull) {
            return ThingsModelFactory.nullFeature(this.featureId);
        }
        return ThingsModelFactory.newFeature(this.featureId, this.definition, this.properties, this.desiredProperties);
    }
}

