/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.things.FeatureProperties;
import org.eclipse.ditto.model.things.FeaturePropertiesBuilder;
import org.eclipse.ditto.model.things.ImmutableFeatureProperties;

@NotThreadSafe
final class ImmutableFeaturePropertiesBuilder
implements FeaturePropertiesBuilder {
    private final JsonObjectBuilder jsonObjectBuilder;

    private ImmutableFeaturePropertiesBuilder(JsonObjectBuilder theJsonObjectBuilder) {
        this.jsonObjectBuilder = theJsonObjectBuilder;
    }

    public static FeaturePropertiesBuilder empty() {
        return new ImmutableFeaturePropertiesBuilder(JsonFactory.newObjectBuilder());
    }

    public static <T extends JsonObject> FeaturePropertiesBuilder of(T jsonObject) {
        return new ImmutableFeaturePropertiesBuilder(JsonFactory.newObjectBuilder(jsonObject));
    }

    @Override
    public FeaturePropertiesBuilder set(CharSequence key, int value, Predicate<JsonField> predicate) {
        this.jsonObjectBuilder.set(key, value, predicate);
        return this;
    }

    @Override
    public FeaturePropertiesBuilder set(CharSequence key, long value, Predicate<JsonField> predicate) {
        this.jsonObjectBuilder.set(key, value, predicate);
        return this;
    }

    @Override
    public FeaturePropertiesBuilder set(CharSequence key, double value, Predicate<JsonField> predicate) {
        this.jsonObjectBuilder.set(key, value, predicate);
        return this;
    }

    @Override
    public FeaturePropertiesBuilder set(CharSequence key, boolean value, Predicate<JsonField> predicate) {
        this.jsonObjectBuilder.set(key, value, predicate);
        return this;
    }

    @Override
    public FeaturePropertiesBuilder set(CharSequence key, @Nullable String value, Predicate<JsonField> predicate) {
        this.jsonObjectBuilder.set(key, value, predicate);
        return this;
    }

    @Override
    public FeaturePropertiesBuilder set(CharSequence key, JsonValue value, Predicate<JsonField> predicate) {
        this.jsonObjectBuilder.set(key, value, predicate);
        return this;
    }

    @Override
    public <T> FeaturePropertiesBuilder set(JsonFieldDefinition<T> fieldDefinition, @Nullable T value, Predicate<JsonField> predicate) {
        this.jsonObjectBuilder.set(fieldDefinition, value, predicate);
        return this;
    }

    @Override
    public FeaturePropertiesBuilder set(JsonField field, Predicate<JsonField> predicate) {
        this.jsonObjectBuilder.set(field, predicate);
        return this;
    }

    @Override
    public FeaturePropertiesBuilder remove(CharSequence key) {
        this.jsonObjectBuilder.remove(key);
        return this;
    }

    @Override
    public FeaturePropertiesBuilder remove(JsonFieldDefinition fieldDefinition) {
        this.jsonObjectBuilder.remove(fieldDefinition);
        return this;
    }

    @Override
    public FeaturePropertiesBuilder setAll(Iterable<JsonField> fields, Predicate<JsonField> predicate) {
        this.jsonObjectBuilder.setAll(fields, predicate);
        return this;
    }

    @Override
    public FeaturePropertiesBuilder removeAll() {
        this.jsonObjectBuilder.removeAll();
        return this;
    }

    public Iterator<JsonField> iterator() {
        return this.jsonObjectBuilder.iterator();
    }

    @Override
    public FeatureProperties build() {
        JsonObject featurePropertiesJsonObject = this.jsonObjectBuilder.build();
        return ImmutableFeatureProperties.of(featurePropertiesJsonObject);
    }

    public boolean isEmpty() {
        return this.jsonObjectBuilder.isEmpty();
    }

    public int getSize() {
        return this.jsonObjectBuilder.getSize();
    }

    public Stream<JsonField> stream() {
        return this.jsonObjectBuilder.stream();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableFeaturePropertiesBuilder that = (ImmutableFeaturePropertiesBuilder)o;
        return Objects.equals(this.jsonObjectBuilder, that.jsonObjectBuilder);
    }

    public int hashCode() {
        return Objects.hash(this.jsonObjectBuilder);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [jsonObjectBuilder=" + this.jsonObjectBuilder + "]";
    }
}

