/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.things.Feature;
import org.eclipse.ditto.model.things.FeatureDefinition;
import org.eclipse.ditto.model.things.FeatureProperties;
import org.eclipse.ditto.model.things.Features;
import org.eclipse.ditto.model.things.ThingsModelFactory;

@Immutable
final class ImmutableFeatures
implements Features {
    private static final JsonFieldDefinition<Integer> JSON_SCHEMA_VERSION = JsonFactory.newIntFieldDefinition((CharSequence)JsonSchemaVersion.getJsonKey(), (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.SPECIAL, FieldType.HIDDEN, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
    private final Map<String, Feature> features;

    private ImmutableFeatures(Map<String, Feature> features) {
        this.features = Collections.unmodifiableMap(new HashMap((Map)ConditionChecker.checkNotNull(features, (String)"features")));
    }

    public static ImmutableFeatures empty() {
        return new ImmutableFeatures(new HashMap<String, Feature>());
    }

    public static ImmutableFeatures of(Iterable<Feature> features) {
        ConditionChecker.checkNotNull(features, (String)"initial features");
        HashMap<String, Feature> featureMap = new HashMap<String, Feature>();
        features.forEach(feature -> featureMap.put(feature.getId(), (Feature)feature));
        return new ImmutableFeatures(featureMap);
    }

    public static ImmutableFeatures of(Feature feature, Feature ... additionalFeatures) {
        ConditionChecker.checkNotNull((Object)feature, (String)"initial Feature");
        ConditionChecker.checkNotNull((Object)additionalFeatures, (String)"additional initial Features");
        HashMap<String, Feature> features = new HashMap<String, Feature>(1 + additionalFeatures.length);
        features.put(feature.getId(), feature);
        for (Feature additionalFeature : additionalFeatures) {
            features.put(additionalFeature.getId(), additionalFeature);
        }
        return new ImmutableFeatures(features);
    }

    @Override
    public Optional<Feature> getFeature(String featureId) {
        ImmutableFeatures.checkFeatureId(featureId);
        return Optional.ofNullable(this.features.get(featureId));
    }

    private static String checkFeatureId(String featureId) {
        return (String)ConditionChecker.checkNotNull((Object)featureId, (String)"Feature ID");
    }

    @Override
    public Features setFeature(Feature feature) {
        ConditionChecker.checkNotNull((Object)feature, (String)"Feature to be set");
        Feature existingFeature = this.getFeatureOrNull(feature.getId());
        if (!Objects.equals(existingFeature, feature)) {
            return this.createNewFeaturesWithNewFeature(feature);
        }
        return this;
    }

    @Nullable
    private Feature getFeatureOrNull(String featureId) {
        return this.features.get(ImmutableFeatures.checkFeatureId(featureId));
    }

    @Nullable
    private Feature getFeatureOrNull(CharSequence featureId) {
        return this.features.get(ImmutableFeatures.checkFeatureId(featureId.toString()));
    }

    private Features createNewFeaturesWithNewFeature(Feature newFeature) {
        Map<String, Feature> featuresCopy = this.copyFeatures();
        featuresCopy.put(newFeature.getId(), newFeature);
        return new ImmutableFeatures(featuresCopy);
    }

    @Override
    public Features removeFeature(String featureId) {
        if (!this.features.containsKey(ImmutableFeatures.checkFeatureId(featureId))) {
            return this;
        }
        Map<String, Feature> featuresCopy = this.copyFeatures();
        featuresCopy.remove(featureId);
        return new ImmutableFeatures(featuresCopy);
    }

    private Map<String, Feature> copyFeatures() {
        return new HashMap<String, Feature>(this.features);
    }

    @Override
    public Features setDefinition(String featureId, FeatureDefinition definition) {
        ConditionChecker.checkNotNull((Object)definition, (String)"definition to be set");
        Feature feature = this.getFeatureOrNull(featureId);
        feature = null != feature ? feature.setDefinition(definition) : ThingsModelFactory.newFeature(featureId, definition);
        return this.setFeature(feature);
    }

    @Override
    public Features removeDefinition(String featureId) {
        Feature feature = this.getFeatureOrNull(featureId);
        if (null != feature) {
            return this.setFeature(feature.removeDefinition());
        }
        return this;
    }

    @Override
    public Features setProperties(String featureId, FeatureProperties properties) {
        ConditionChecker.checkNotNull((Object)properties, (String)"properties to be set");
        Feature feature = this.getFeatureOrNull(featureId);
        feature = null != feature ? feature.setProperties(properties) : ThingsModelFactory.newFeature(featureId, properties);
        return this.setFeature(feature);
    }

    @Override
    public Features removeProperties(String featureId) {
        Feature feature = this.getFeatureOrNull(featureId);
        if (null != feature) {
            return this.setFeature(feature.removeProperties());
        }
        return this;
    }

    @Override
    public Features setProperty(String featureId, JsonPointer propertyPath, JsonValue propertyValue) {
        Feature feature = this.getFeatureOrNull(featureId);
        feature = null != feature ? feature.setProperty(propertyPath, propertyValue) : ThingsModelFactory.newFeature(featureId, ThingsModelFactory.newFeaturePropertiesBuilder().set((CharSequence)propertyPath, propertyValue).build());
        return this.setFeature(feature);
    }

    @Override
    public Features removeProperty(String featureId, JsonPointer propertyPath) {
        Feature feature = this.getFeatureOrNull(featureId);
        if (null != feature) {
            return this.setFeature(feature.removeProperty(propertyPath));
        }
        return this;
    }

    @Override
    public Features setDesiredProperties(CharSequence featureId, FeatureProperties desiredProperties) {
        ConditionChecker.checkNotNull((Object)desiredProperties, (String)"desiredProperties");
        Feature feature = this.getFeatureOrNull(featureId);
        feature = null != feature ? feature.setDesiredProperties(desiredProperties) : ThingsModelFactory.newFeature(featureId, null, null, desiredProperties);
        return this.setFeature(feature);
    }

    @Override
    public Features removeDesiredProperties(CharSequence featureId) {
        Feature feature = this.getFeatureOrNull(featureId);
        if (null != feature) {
            return this.setFeature(feature.removeDesiredProperties());
        }
        return this;
    }

    @Override
    public Features setDesiredProperty(CharSequence featureId, JsonPointer desiredPropertyPath, JsonValue desiredPropertyValue) {
        Feature feature = this.getFeatureOrNull(featureId);
        feature = null != feature ? feature.setDesiredProperty(desiredPropertyPath, desiredPropertyValue) : ThingsModelFactory.newFeature(featureId, null, null, ThingsModelFactory.newFeaturePropertiesBuilder().set((CharSequence)desiredPropertyPath, desiredPropertyValue).build());
        return this.setFeature(feature);
    }

    @Override
    public Features removeDesiredProperty(CharSequence featureId, JsonPointer desiredPropertyPath) {
        Feature feature = this.getFeatureOrNull(featureId);
        if (null != feature) {
            return this.setFeature(feature.removeDesiredProperty(desiredPropertyPath));
        }
        return this;
    }

    @Override
    public int getSize() {
        return this.features.size();
    }

    @Override
    public boolean isEmpty() {
        return this.features.isEmpty();
    }

    @Override
    public Stream<Feature> stream() {
        return this.features.values().stream();
    }

    @Override
    public Iterator<Feature> iterator() {
        return new HashSet<Feature>(this.features.values()).iterator();
    }

    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        JsonObjectBuilder jsonObjectBuilder = JsonFactory.newObjectBuilder();
        jsonObjectBuilder.set(JSON_SCHEMA_VERSION, (Object)schemaVersion.toInt(), predicate);
        this.features.values().forEach(feature -> {
            JsonKey key = JsonFactory.newKey((CharSequence)feature.getId());
            JsonValue value = feature.toJson(schemaVersion, thePredicate);
            JsonFieldDefinition fieldDefinition = JsonFactory.newJsonObjectFieldDefinition((CharSequence)key, (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
            JsonField field = JsonFactory.newField((JsonKey)key, (JsonValue)value, (JsonFieldDefinition)fieldDefinition);
            jsonObjectBuilder.set(field, predicate);
        });
        return jsonObjectBuilder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableFeatures that = (ImmutableFeatures)o;
        return Objects.equals(this.features, that.features);
    }

    public int hashCode() {
        return Objects.hash(this.features);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [features=" + this.features.values() + "]";
    }
}

