/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.things.Feature;
import org.eclipse.ditto.model.things.Features;
import org.eclipse.ditto.model.things.FeaturesBuilder;
import org.eclipse.ditto.model.things.ImmutableFeatures;

@NotThreadSafe
final class ImmutableFeaturesBuilder
implements FeaturesBuilder {
    private final Map<String, Feature> features;

    private ImmutableFeaturesBuilder(Map<String, Feature> theFeatures) {
        this.features = theFeatures;
    }

    public static FeaturesBuilder newInstance() {
        return new ImmutableFeaturesBuilder(new HashMap<String, Feature>());
    }

    @Override
    public FeaturesBuilder set(Feature feature) {
        ConditionChecker.checkNotNull((Object)feature, (String)"feature to be set");
        this.features.put(feature.getId(), feature);
        return this;
    }

    @Override
    public Optional<Feature> get(CharSequence featureId) {
        ConditionChecker.checkNotNull((Object)featureId, (String)"ID of the Feature to be returned");
        return Optional.ofNullable(this.features.get(featureId.toString()));
    }

    @Override
    public FeaturesBuilder setAll(Iterable<Feature> features) {
        ConditionChecker.checkNotNull(features, (String)"features to be set");
        features.forEach(f -> this.features.put(f.getId(), (Feature)f));
        return this;
    }

    @Override
    public FeaturesBuilder remove(Feature feature) {
        ConditionChecker.checkNotNull((Object)feature, (String)"feature to be removed");
        this.features.remove(feature.getId());
        return this;
    }

    @Override
    public FeaturesBuilder remove(String featureId) {
        ConditionChecker.checkNotNull((Object)featureId, (String)"identifier of the feature to be removed");
        this.features.remove(featureId);
        return this;
    }

    @Override
    public FeaturesBuilder removeAll() {
        this.features.clear();
        return this;
    }

    @Override
    public Features build() {
        return ImmutableFeatures.of(this.features.values());
    }

    @Override
    public Iterator<Feature> iterator() {
        return this.features.values().iterator();
    }
}

