/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import java.util.Objects;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.things.DefinitionIdentifier;
import org.eclipse.ditto.model.things.ImmutableDefinitionIdentifier;
import org.eclipse.ditto.model.things.ThingDefinition;

final class ImmutableThingDefinition
implements ThingDefinition {
    private final DefinitionIdentifier delegate;

    private ImmutableThingDefinition(DefinitionIdentifier delegate) {
        this.delegate = delegate;
    }

    private ImmutableThingDefinition(CharSequence theNamespace, CharSequence theName, CharSequence theVersion) {
        this(ImmutableDefinitionIdentifier.getInstance(theNamespace, theName, theVersion));
    }

    public static ImmutableThingDefinition getInstance(CharSequence namespace, CharSequence name, CharSequence version) {
        return new ImmutableThingDefinition(namespace, name, version);
    }

    public static ImmutableThingDefinition ofParsed(CharSequence thingDefinitionIdentifier) {
        ConditionChecker.checkNotNull((Object)thingDefinitionIdentifier, (String)"CharSequence-representation of the identifier");
        if (thingDefinitionIdentifier instanceof ImmutableThingDefinition) {
            return (ImmutableThingDefinition)thingDefinitionIdentifier;
        }
        return new ImmutableThingDefinition(ImmutableDefinitionIdentifier.ofParsed(thingDefinitionIdentifier));
    }

    @Override
    public String getNamespace() {
        return this.delegate.getNamespace();
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public String getVersion() {
        return this.delegate.getVersion();
    }

    public JsonValue toJson() {
        return JsonValue.of((String)this.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableThingDefinition that = (ImmutableThingDefinition)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return Objects.hash(this.delegate);
    }

    @Override
    public int length() {
        return this.delegate.length();
    }

    @Override
    public char charAt(int index) {
        return this.delegate.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.delegate.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }
}

