/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import java.text.MessageFormat;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.auth.AuthorizationSubject;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.entity.metadata.Metadata;
import org.eclipse.ditto.model.policies.PolicyId;
import org.eclipse.ditto.model.things.AccessControlList;
import org.eclipse.ditto.model.things.AclEntry;
import org.eclipse.ditto.model.things.Attributes;
import org.eclipse.ditto.model.things.Feature;
import org.eclipse.ditto.model.things.FeatureDefinition;
import org.eclipse.ditto.model.things.FeatureProperties;
import org.eclipse.ditto.model.things.Features;
import org.eclipse.ditto.model.things.ImmutableThingFromScratchBuilder;
import org.eclipse.ditto.model.things.Permission;
import org.eclipse.ditto.model.things.Permissions;
import org.eclipse.ditto.model.things.Thing;
import org.eclipse.ditto.model.things.ThingBuilder;
import org.eclipse.ditto.model.things.ThingDefinition;
import org.eclipse.ditto.model.things.ThingId;
import org.eclipse.ditto.model.things.ThingLifecycle;
import org.eclipse.ditto.model.things.ThingRevision;
import org.eclipse.ditto.model.things.ThingsModelFactory;

@NotThreadSafe
final class ImmutableThingFromCopyBuilder
implements ThingBuilder,
ThingBuilder.FromCopy {
    private final ImmutableThingFromScratchBuilder fromScratchBuilder = ImmutableThingFromScratchBuilder.newInstance();

    private ImmutableThingFromCopyBuilder() {
    }

    public static ImmutableThingFromCopyBuilder of(Thing thing) {
        ConditionChecker.checkNotNull((Object)thing, (String)"Thing");
        ImmutableThingFromCopyBuilder result = new ImmutableThingFromCopyBuilder();
        thing.getEntityId().ifPresent(result::setId);
        thing.getAccessControlList().ifPresent(result::setPermissions);
        thing.getPolicyEntityId().ifPresent(result::setPolicyId);
        thing.getAttributes().ifPresent(result::setAttributes);
        thing.getDefinition().ifPresent(result::setDefinition);
        thing.getFeatures().ifPresent(result::setFeatures);
        thing.getLifecycle().ifPresent(result::setLifecycle);
        thing.getRevision().ifPresent(result::setRevision);
        thing.getModified().ifPresent(result::setModified);
        thing.getCreated().ifPresent(result::setCreated);
        thing.getMetadata().ifPresent(result::setMetadata);
        return result;
    }

    public static ImmutableThingFromCopyBuilder of(JsonObject jsonObject) {
        ConditionChecker.checkNotNull((Object)jsonObject, (String)"JSON object");
        ImmutableThingFromCopyBuilder result = new ImmutableThingFromCopyBuilder();
        jsonObject.getValue(Thing.JsonFields.ID).map(ThingId::of).ifPresent(result::setId);
        jsonObject.getValue(Thing.JsonFields.ACL).map(ThingsModelFactory::newAcl).ifPresent(result::setPermissions);
        jsonObject.getValue(Thing.JsonFields.POLICY_ID).map(PolicyId::of).ifPresent(result::setPolicyId);
        jsonObject.getValue(Thing.JsonFields.ATTRIBUTES).map(ThingsModelFactory::newAttributes).ifPresent(result::setAttributes);
        jsonObject.getValue(Thing.JsonFields.DEFINITION).map(jsonValue -> {
            if (jsonValue.isNull()) {
                return ThingsModelFactory.nullDefinition();
            }
            return ThingsModelFactory.newDefinition(jsonValue.asString());
        }).ifPresent(result::setDefinition);
        jsonObject.getValue(Thing.JsonFields.FEATURES).map(ThingsModelFactory::newFeatures).ifPresent(result::setFeatures);
        jsonObject.getValue(Thing.JsonFields.LIFECYCLE).flatMap(ThingLifecycle::forName).ifPresent(result::setLifecycle);
        jsonObject.getValue(Thing.JsonFields.REVISION).map(ThingsModelFactory::newThingRevision).ifPresent(result::setRevision);
        jsonObject.getValue(Thing.JsonFields.MODIFIED).map(ImmutableThingFromCopyBuilder::tryToParseModified).ifPresent(result::setModified);
        jsonObject.getValue(Thing.JsonFields.CREATED).map(ImmutableThingFromCopyBuilder::tryToParseCreated).ifPresent(result::setCreated);
        jsonObject.getValue(Thing.JsonFields.METADATA).map(ThingsModelFactory::newMetadata).ifPresent(result::setMetadata);
        return result;
    }

    private static Instant tryToParseModified(CharSequence dateTime) {
        return ImmutableThingFromCopyBuilder.tryToParseDate(dateTime, Thing.JsonFields.MODIFIED);
    }

    private static Instant tryToParseCreated(CharSequence dateTime) {
        return ImmutableThingFromCopyBuilder.tryToParseDate(dateTime, Thing.JsonFields.CREATED);
    }

    private static Instant tryToParseDate(CharSequence dateTime, JsonFieldDefinition<String> field) {
        try {
            return Instant.parse(dateTime);
        }
        catch (DateTimeParseException e) {
            String msgPattern = "The JSON object''s field <{0}> is not in ISO-8601 format as expected!";
            throw (JsonParseException)JsonParseException.newBuilder().message(MessageFormat.format("The JSON object''s field <{0}> is not in ISO-8601 format as expected!", field.getPointer())).cause((Throwable)e).build();
        }
    }

    @Override
    @Deprecated
    public ThingBuilder.FromCopy setPermissions(AuthorizationSubject authorizationSubject, Permission permission, Permission ... furtherPermissions) {
        this.fromScratchBuilder.setPermissions(authorizationSubject, permission, furtherPermissions);
        return this;
    }

    @Override
    @Deprecated
    public ThingBuilder.FromCopy setPermissions(Predicate<AccessControlList> existingAclPredicate, AuthorizationSubject authorizationSubject, Permission permission, Permission ... furtherPermissions) {
        if (this.testAclPredicate(existingAclPredicate)) {
            this.setPermissions(authorizationSubject, permission, furtherPermissions);
        }
        return this;
    }

    @Override
    @Deprecated
    public ThingBuilder.FromCopy setPermissions(AuthorizationSubject authorizationSubject, Permissions permissions) {
        this.fromScratchBuilder.setPermissions(authorizationSubject, permissions);
        return this;
    }

    @Override
    @Deprecated
    public ThingBuilder.FromCopy setPermissions(Predicate<AccessControlList> existingAclPredicate, AuthorizationSubject authorizationSubject, Permissions permissions) {
        if (this.testAclPredicate(existingAclPredicate)) {
            this.setPermissions(authorizationSubject, permissions);
        }
        return this;
    }

    @Override
    @Deprecated
    public ThingBuilder.FromCopy setPermissions(Iterable<AclEntry> aclEntries) {
        this.fromScratchBuilder.setPermissions(aclEntries);
        return this;
    }

    @Override
    @Deprecated
    public ThingBuilder.FromCopy setPermissions(Predicate<AccessControlList> existingAclPredicate, Iterable<AclEntry> aclEntries) {
        if (this.testAclPredicate(existingAclPredicate)) {
            this.setPermissions(aclEntries);
        }
        return this;
    }

    @Override
    @Deprecated
    public ThingBuilder.FromCopy setPermissions(JsonObject accessControlListJsonObject) {
        this.fromScratchBuilder.setPermissions(accessControlListJsonObject);
        return this;
    }

    @Override
    @Deprecated
    public ThingBuilder.FromCopy setPermissions(Predicate<AccessControlList> existingAclPredicate, JsonObject accessControlListJsonObject) {
        if (this.testAclPredicate(existingAclPredicate)) {
            this.setPermissions(accessControlListJsonObject);
        }
        return this;
    }

    @Override
    @Deprecated
    public ThingBuilder.FromCopy setPermissions(String accessControlListJsonString) {
        this.fromScratchBuilder.setPermissions(accessControlListJsonString);
        return this;
    }

    @Override
    @Deprecated
    public ThingBuilder.FromCopy setPermissions(Predicate<AccessControlList> existingAclPredicate, String accessControlListJsonString) {
        if (this.testAclPredicate(existingAclPredicate)) {
            this.setPermissions(accessControlListJsonString);
        }
        return this;
    }

    @Override
    @Deprecated
    public ThingBuilder.FromCopy setPermissions(AclEntry aclEntry, AclEntry ... furtherAclEntries) {
        this.fromScratchBuilder.setPermissions(aclEntry, furtherAclEntries);
        return this;
    }

    @Override
    @Deprecated
    public ThingBuilder.FromCopy setPermissions(Predicate<AccessControlList> existingAclPredicate, AclEntry aclEntry, AclEntry ... furtherAclEntries) {
        if (this.testAclPredicate(existingAclPredicate)) {
            this.setPermissions(aclEntry, furtherAclEntries);
        }
        return this;
    }

    @Override
    @Deprecated
    public ThingBuilder.FromCopy removePermissionsOf(AuthorizationSubject authorizationSubject) {
        this.fromScratchBuilder.removePermissionsOf(authorizationSubject);
        return this;
    }

    @Override
    @Deprecated
    public ThingBuilder.FromCopy removePermissionsOf(Predicate<AccessControlList> existingAclPredicate, AuthorizationSubject authorizationSubject) {
        if (this.testAclPredicate(existingAclPredicate)) {
            this.removePermissionsOf(authorizationSubject);
        }
        return this;
    }

    @Override
    @Deprecated
    public ThingBuilder.FromCopy removeAllPermissions() {
        this.fromScratchBuilder.removeAllPermissions();
        return this;
    }

    @Override
    @Deprecated
    public ThingBuilder.FromCopy removeAllPermissions(Predicate<AccessControlList> existingAclPredicate) {
        if (this.testAclPredicate(existingAclPredicate)) {
            return this.removeAllPermissions();
        }
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setPolicyId(@Nullable PolicyId policyId) {
        this.fromScratchBuilder.setPolicyId(policyId);
        return this;
    }

    @Override
    public ThingBuilder.FromCopy removePolicyId() {
        this.fromScratchBuilder.removePolicyId();
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setAttributes(Attributes attributes) {
        this.fromScratchBuilder.setAttributes(attributes);
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setAttributes(Predicate<Attributes> existingAttributesPredicate, Attributes attributes) {
        if (this.testAttributesPredicate(existingAttributesPredicate)) {
            return this.setAttributes(attributes);
        }
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setAttributes(JsonObject attributesJsonObject) {
        this.fromScratchBuilder.setAttributes(attributesJsonObject);
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setAttributes(Predicate<Attributes> existingAttributesPredicate, JsonObject attributesJsonObject) {
        if (this.testAttributesPredicate(existingAttributesPredicate)) {
            this.setAttributes(attributesJsonObject);
        }
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setAttributes(String attributesJsonString) {
        return this.setAttributes(ThingsModelFactory.newAttributes(attributesJsonString));
    }

    @Override
    public ThingBuilder.FromCopy setAttributes(Predicate<Attributes> existingAttributesPredicate, String attributesJsonString) {
        if (this.testAttributesPredicate(existingAttributesPredicate)) {
            return this.setAttributes(attributesJsonString);
        }
        return this;
    }

    @Override
    public ThingBuilder.FromCopy removeAllAttributes() {
        this.fromScratchBuilder.removeAllAttributes();
        return this;
    }

    @Override
    public ThingBuilder.FromCopy removeAttribute(JsonPointer attributePath) {
        this.fromScratchBuilder.removeAttribute(attributePath);
        return this;
    }

    @Override
    public ThingBuilder.FromCopy removeAttribute(Predicate<Attributes> existingAttributesPredicate, JsonPointer attributePath) {
        if (this.testAttributesPredicate(existingAttributesPredicate)) {
            this.removeAttribute(attributePath);
        }
        return this;
    }

    @Override
    public ThingBuilder.FromCopy removeAllAttributes(Predicate<Attributes> existingAttributesPredicate) {
        if (this.testAttributesPredicate(existingAttributesPredicate)) {
            this.removeAllAttributes();
        }
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setNullAttributes() {
        this.fromScratchBuilder.setNullAttributes();
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setAttribute(JsonPointer attributePath, JsonValue attributeValue) {
        this.fromScratchBuilder.setAttribute(attributePath, attributeValue);
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setAttribute(Predicate<Attributes> existingAttributesPredicate, JsonPointer attributePath, JsonValue attributeValue) {
        if (this.testAttributesPredicate(existingAttributesPredicate)) {
            this.setAttribute(attributePath, attributeValue);
        }
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setDefinition(@Nullable ThingDefinition definition) {
        this.fromScratchBuilder.setDefinition(definition);
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setNullDefinition() {
        this.fromScratchBuilder.setNullDefinition();
        return this;
    }

    @Override
    public ThingBuilder.FromCopy removeDefinition() {
        this.fromScratchBuilder.removeDefinition();
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setFeature(Feature feature) {
        this.fromScratchBuilder.setFeature(feature);
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setFeature(Predicate<Features> existingFeaturesPredicate, Feature feature) {
        if (this.testFeaturesPredicate(existingFeaturesPredicate)) {
            this.setFeature(feature);
        }
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setFeature(String featureId) {
        return this.setFeature(ThingsModelFactory.newFeature(featureId));
    }

    @Override
    public ThingBuilder.FromCopy setFeature(Predicate<Features> existingFeaturesPredicate, String featureId) {
        if (this.testFeaturesPredicate(existingFeaturesPredicate)) {
            this.setFeature(featureId);
        }
        return this;
    }

    @Override
    public ThingBuilder.FromCopy removeFeature(String featureId) {
        Features features = this.fromScratchBuilder.getFeatures();
        if (null != features && !features.isEmpty() && !features.isNull()) {
            this.fromScratchBuilder.removeFeature(featureId);
            if (this.fromScratchBuilder.getFeatures() == null) {
                this.fromScratchBuilder.setEmptyFeatures();
            }
        }
        return this;
    }

    @Override
    public ThingBuilder.FromCopy removeFeature(Predicate<Features> existingFeaturesPredicate, String featureId) {
        if (this.testFeaturesPredicate(existingFeaturesPredicate)) {
            this.removeFeature(featureId);
        }
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setFeature(Predicate<Features> existingFeaturesPredicate, String featureId, FeatureDefinition featureDefinition, FeatureProperties featureProperties) {
        if (this.testFeaturesPredicate(existingFeaturesPredicate)) {
            this.setFeature(featureId, featureDefinition, featureProperties);
        }
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setFeature(Predicate<Features> existingFeaturesPredicate, CharSequence featureId, FeatureDefinition featureDefinition, FeatureProperties featureProperties, FeatureProperties featureDesiredProperties) {
        if (this.testFeaturesPredicate(existingFeaturesPredicate)) {
            this.setFeature(featureId, featureDefinition, featureProperties, featureDesiredProperties);
        }
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setFeature(CharSequence featureId, @Nullable FeatureDefinition featureDefinition, @Nullable FeatureProperties featureProperties, @Nullable FeatureProperties featureDesiredProperties) {
        this.fromScratchBuilder.setFeature(featureId, featureDefinition, featureProperties, featureDesiredProperties);
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setFeature(String featureId, FeatureDefinition featureDefinition, FeatureProperties featureProperties) {
        this.fromScratchBuilder.setFeature(featureId, featureDefinition, featureProperties);
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setFeature(String featureId, FeatureProperties featureProperties) {
        this.fromScratchBuilder.setFeature(featureId, featureProperties);
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setFeature(Predicate<Features> existingFeaturesPredicate, String featureId, FeatureProperties featureProperties) {
        if (this.testFeaturesPredicate(existingFeaturesPredicate)) {
            this.setFeature(featureId, featureProperties);
        }
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setFeatureDefinition(Predicate<Features> existingFeaturesPredicate, String featureId, FeatureDefinition featureDefinition) {
        if (this.testFeaturesPredicate(existingFeaturesPredicate)) {
            this.fromScratchBuilder.setFeatureDefinition(featureId, featureDefinition);
        }
        return this;
    }

    @Override
    public ThingBuilder.FromCopy removeFeatureDefinition(String featureId) {
        this.fromScratchBuilder.removeFeatureDefinition(featureId);
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setFeatureProperty(String featureId, JsonPointer propertyPath, JsonValue propertyValue) {
        this.fromScratchBuilder.setFeatureProperty(featureId, propertyPath, propertyValue);
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setFeatureProperty(Predicate<Features> existingFeaturesPredicate, String featureId, JsonPointer propertyPath, JsonValue propertyValue) {
        if (this.testFeaturesPredicate(existingFeaturesPredicate)) {
            this.fromScratchBuilder.setFeatureProperty(featureId, propertyPath, propertyValue);
        }
        return this;
    }

    @Override
    public ThingBuilder.FromCopy removeFeatureProperty(String featureId, JsonPointer propertyPath) {
        this.fromScratchBuilder.removeFeatureProperty(featureId, propertyPath);
        return this;
    }

    @Override
    public ThingBuilder.FromCopy removeFeatureProperty(Predicate<Features> existingFeaturesPredicate, String featureId, JsonPointer propertyPath) {
        if (this.testFeaturesPredicate(existingFeaturesPredicate)) {
            this.fromScratchBuilder.removeFeatureProperty(featureId, propertyPath);
        }
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setFeatureProperties(Predicate<Features> existingFeaturesPredicate, String featureId, FeatureProperties featureProperties) {
        if (this.testFeaturesPredicate(existingFeaturesPredicate)) {
            this.fromScratchBuilder.setFeatureProperties(featureId, featureProperties);
        }
        return this;
    }

    @Override
    public ThingBuilder.FromCopy removeFeatureProperties(Predicate<Features> existingFeaturesPredicate, String featureId) {
        if (this.testFeaturesPredicate(existingFeaturesPredicate)) {
            this.fromScratchBuilder.removeFeatureProperties(featureId);
        }
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setFeatureDesiredProperty(CharSequence featureId, JsonPointer desiredPropertyPath, JsonValue desiredPropertyValue) {
        this.fromScratchBuilder.setFeatureDesiredProperty(featureId, desiredPropertyPath, desiredPropertyValue);
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setFeatureDesiredProperty(Predicate<Features> existingFeaturesPredicate, CharSequence featureId, JsonPointer desiredPropertyPath, JsonValue desiredPropertyValue) {
        if (this.testFeaturesPredicate(existingFeaturesPredicate)) {
            this.fromScratchBuilder.setFeatureDesiredProperty(featureId, desiredPropertyPath, desiredPropertyValue);
        }
        return this;
    }

    @Override
    public ThingBuilder.FromCopy removeFeatureDesiredProperty(CharSequence featureId, JsonPointer desiredPropertyPath) {
        this.fromScratchBuilder.removeFeatureDesiredProperty(featureId, desiredPropertyPath);
        return this;
    }

    @Override
    public ThingBuilder.FromCopy removeFeatureDesiredProperty(Predicate<Features> existingFeaturesPredicate, CharSequence featureId, JsonPointer desiredPropertyPath) {
        if (this.testFeaturesPredicate(existingFeaturesPredicate)) {
            this.fromScratchBuilder.removeFeatureDesiredProperty(featureId, desiredPropertyPath);
        }
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setFeatureDesiredProperties(Predicate<Features> existingFeaturesPredicate, CharSequence featureId, FeatureProperties desiredProperties) {
        if (this.testFeaturesPredicate(existingFeaturesPredicate)) {
            this.fromScratchBuilder.setFeatureDesiredProperties(featureId, desiredProperties);
        }
        return this;
    }

    @Override
    public ThingBuilder.FromCopy removeFeatureDesiredProperties(Predicate<Features> existingFeaturesPredicate, CharSequence featureId) {
        if (this.testFeaturesPredicate(existingFeaturesPredicate)) {
            this.fromScratchBuilder.removeFeatureDesiredProperties(featureId);
        }
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setFeatures(JsonObject featuresJsonObject) {
        return this.setFeatures(ThingsModelFactory.newFeatures(featuresJsonObject));
    }

    @Override
    public ThingBuilder.FromCopy setFeatures(Predicate<Features> existingFeaturesPredicate, JsonObject featuresJsonObject) {
        if (this.testFeaturesPredicate(existingFeaturesPredicate)) {
            this.setFeatures(featuresJsonObject);
        }
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setFeatures(String featuresJsonString) {
        return this.setFeatures(ThingsModelFactory.newFeatures(featuresJsonString));
    }

    @Override
    public ThingBuilder.FromCopy setFeatures(Predicate<Features> existingFeaturesPredicate, String featuresJsonString) {
        if (this.testFeaturesPredicate(existingFeaturesPredicate)) {
            this.setFeatures(featuresJsonString);
        }
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setFeatures(Iterable<Feature> features) {
        this.fromScratchBuilder.setFeatures(features);
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setFeatures(Predicate<Features> existingFeaturesPredicate, Iterable<Feature> features) {
        if (this.testFeaturesPredicate(existingFeaturesPredicate)) {
            this.setFeatures(features);
        }
        return this;
    }

    @Override
    public ThingBuilder.FromCopy removeAllFeatures() {
        this.fromScratchBuilder.removeAllFeatures();
        return this;
    }

    @Override
    public ThingBuilder.FromCopy removeAllFeatures(Predicate<Features> existingFeaturesPredicate) {
        if (this.testFeaturesPredicate(existingFeaturesPredicate)) {
            this.removeAllFeatures();
        }
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setNullFeatures() {
        this.fromScratchBuilder.setNullFeatures();
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setLifecycle(@Nullable ThingLifecycle lifecycle) {
        this.fromScratchBuilder.setLifecycle(lifecycle);
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setLifecycle(Predicate<ThingLifecycle> existingLifecyclePredicate, @Nullable ThingLifecycle lifecycle) {
        if (existingLifecyclePredicate.test(this.fromScratchBuilder.lifecycle)) {
            this.setLifecycle(lifecycle);
        }
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setRevision(@Nullable ThingRevision revision) {
        this.fromScratchBuilder.setRevision(revision);
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setRevision(Predicate<ThingRevision> existingRevisionPredicate, @Nullable ThingRevision revision) {
        if (existingRevisionPredicate.test(this.fromScratchBuilder.revision)) {
            this.setRevision(revision);
        }
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setRevision(long revisionNumber) {
        this.fromScratchBuilder.setRevision(revisionNumber);
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setRevision(Predicate<ThingRevision> existingRevisionPredicate, long revisionNumber) {
        if (existingRevisionPredicate.test(this.fromScratchBuilder.revision)) {
            this.setRevision(revisionNumber);
        }
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setModified(@Nullable Instant modified) {
        this.fromScratchBuilder.setModified(modified);
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setModified(Predicate<Instant> existingModifiedPredicate, @Nullable Instant modified) {
        if (existingModifiedPredicate.test(this.fromScratchBuilder.modified)) {
            this.setModified(modified);
        }
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setCreated(@Nullable Instant created) {
        this.fromScratchBuilder.setCreated(created);
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setCreated(Predicate<Instant> existingCreatedPredicate, @Nullable Instant created) {
        if (existingCreatedPredicate.test(this.fromScratchBuilder.created)) {
            this.setCreated(created);
        }
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setMetadata(@Nullable Metadata metadata) {
        this.fromScratchBuilder.setMetadata(metadata);
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setMetadata(Predicate<Metadata> existingMetadataPredicate, @Nullable Metadata metadata) {
        if (existingMetadataPredicate.test(this.fromScratchBuilder.metadata)) {
            this.setMetadata(metadata);
        }
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setId(@Nullable String thingId) {
        this.fromScratchBuilder.setId(thingId);
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setId(@Nullable ThingId thingId) {
        this.fromScratchBuilder.setId(thingId);
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setId(Predicate<ThingId> existingIdPredicate, @Nullable ThingId thingId) {
        if (existingIdPredicate.test(this.fromScratchBuilder.id)) {
            this.setId(thingId);
        }
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setGeneratedId() {
        this.fromScratchBuilder.setGeneratedId();
        return this;
    }

    @Override
    public ThingBuilder.FromCopy setGeneratedId(Predicate<ThingId> existingIdPredicate) {
        if (existingIdPredicate.test(this.fromScratchBuilder.id)) {
            this.setGeneratedId();
        }
        return this;
    }

    @Override
    public Thing build() {
        return this.fromScratchBuilder.build();
    }

    @Deprecated
    private boolean testAclPredicate(Predicate<AccessControlList> existingAclPredicate) {
        return existingAclPredicate.test(this.fromScratchBuilder.getAcl());
    }

    private boolean testAttributesPredicate(Predicate<Attributes> existingAttributesPredicate) {
        return existingAttributesPredicate.test(this.fromScratchBuilder.getAttributes());
    }

    private boolean testFeaturesPredicate(Predicate<Features> existingFeaturesPredicate) {
        ConditionChecker.checkNotNull(existingFeaturesPredicate, (String)"predicate for existing Features");
        return existingFeaturesPredicate.test(this.fromScratchBuilder.getFeatures());
    }
}

