/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableException;
import org.eclipse.ditto.model.things.ThingException;
import org.eclipse.ditto.model.things.ThingFieldSelector;

@JsonParsableException(errorCode="things:field.selection.invalid")
public final class InvalidThingFieldSelectionException
extends DittoRuntimeException
implements ThingException {
    private static final String DEFAULT_MESSAGE_TEMPLATE = "Thing field selection <{0}> was not valid.";
    private static final String DEFAULT_DESCRIPTION = "Please provide a comma separated List of valid Thing fields.Make sure that you did not use a space after a comma. Valid Fields are: " + ThingFieldSelector.SELECTABLE_FIELDS.toString();
    static final String ERROR_CODE = "things:field.selection.invalid";

    private InvalidThingFieldSelectionException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, message, description, cause, href);
    }

    static InvalidThingFieldSelectionException forExtraFieldSelectionString(String extraFieldString) {
        return (InvalidThingFieldSelectionException)new Builder(MessageFormat.format(DEFAULT_MESSAGE_TEMPLATE, extraFieldString)).build();
    }

    public static InvalidThingFieldSelectionException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (InvalidThingFieldSelectionException)DittoRuntimeException.fromJson((JsonObject)jsonObject, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<InvalidThingFieldSelectionException> {
        private Builder() {
            this.description(DEFAULT_DESCRIPTION);
        }

        private Builder(String message) {
            this.description(DEFAULT_DESCRIPTION);
            this.message(message);
        }

        protected InvalidThingFieldSelectionException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new InvalidThingFieldSelectionException(dittoHeaders, message, description, cause, href);
        }
    }
}

