/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonKeyInvalidException;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.entity.validation.NoControlCharactersNoSlashesValidator;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.things.Feature;
import org.eclipse.ditto.model.things.FeatureDefinition;
import org.eclipse.ditto.model.things.FeatureProperties;

@Immutable
final class NullFeature
implements Feature {
    private final String featureId;

    private NullFeature(String featureId) {
        this.featureId = (String)ConditionChecker.checkNotNull((Object)featureId, (String)"ID");
    }

    public static NullFeature of(String featureId) {
        ConditionChecker.checkNotNull((Object)featureId, (String)"ID of the Feature");
        NoControlCharactersNoSlashesValidator validator = NoControlCharactersNoSlashesValidator.getInstance((CharSequence)featureId);
        if (!validator.isValid()) {
            throw (JsonKeyInvalidException)JsonKeyInvalidException.newBuilderWithDescription((CharSequence)featureId, (String)validator.getReason().orElse(null)).build();
        }
        return new NullFeature(featureId);
    }

    @Override
    public String getId() {
        return this.featureId;
    }

    @Override
    public Optional<FeatureDefinition> getDefinition() {
        return Optional.empty();
    }

    @Override
    public Feature setDefinition(FeatureDefinition featureDefinition) {
        return this;
    }

    @Override
    public Feature removeDefinition() {
        return this;
    }

    @Override
    public Optional<FeatureProperties> getProperties() {
        return Optional.empty();
    }

    @Override
    public Feature setProperties(FeatureProperties properties) {
        return this;
    }

    @Override
    public Feature removeProperties() {
        return this;
    }

    @Override
    public Optional<JsonValue> getProperty(JsonPointer pointer) {
        return Optional.empty();
    }

    @Override
    public Feature setProperty(JsonPointer pointer, JsonValue propertyValue) {
        return this;
    }

    @Override
    public Feature removeProperty(JsonPointer pointer) {
        return this;
    }

    @Override
    public Optional<FeatureProperties> getDesiredProperties() {
        return Optional.empty();
    }

    @Override
    public Feature setDesiredProperties(FeatureProperties desiredProperties) {
        return this;
    }

    @Override
    public Feature removeDesiredProperties() {
        return this;
    }

    @Override
    public Optional<JsonValue> getDesiredProperty(JsonPointer pointer) {
        return Optional.empty();
    }

    @Override
    public Feature setDesiredProperty(JsonPointer pointer, JsonValue desiredPropertyValue) {
        return this;
    }

    @Override
    public Feature removeDesiredProperty(JsonPointer pointer) {
        return this;
    }

    @Override
    public JsonObject toJson() {
        return JsonFactory.nullObject();
    }

    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        return JsonFactory.nullObject();
    }

    public int hashCode() {
        return Objects.hash(this.featureId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NullFeature other = (NullFeature)o;
        return Objects.equals(this.featureId, other.featureId);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [featureId=" + this.featureId + "]";
    }
}

