/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.model.things.DefinitionIdentifier;
import org.eclipse.ditto.model.things.FeatureDefinition;

@Immutable
final class NullFeatureDefinition
implements FeatureDefinition {
    private final JsonArray wrapped = JsonFactory.nullArray();

    private NullFeatureDefinition() {
    }

    public static FeatureDefinition getInstance() {
        return new NullFeatureDefinition();
    }

    @Override
    public DefinitionIdentifier getFirstIdentifier() {
        return new NullIdentifier();
    }

    @Override
    public int getSize() {
        return 0;
    }

    @Override
    public Stream<DefinitionIdentifier> stream() {
        return Stream.empty();
    }

    @Override
    public Iterator<DefinitionIdentifier> iterator() {
        List emptyList = Collections.emptyList();
        return emptyList.iterator();
    }

    public JsonArray toJson() {
        return this.wrapped;
    }

    public int hashCode() {
        return Objects.hash(this.wrapped);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NullFeatureDefinition other = (NullFeatureDefinition)o;
        return Objects.equals(this.wrapped, other.wrapped);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [wrapped=" + this.wrapped + "]";
    }

    private static final class NullIdentifier
    implements DefinitionIdentifier {
        private NullIdentifier() {
        }

        @Override
        public String getNamespace() {
            return "";
        }

        @Override
        public String getName() {
            return "";
        }

        @Override
        public String getVersion() {
            return "";
        }

        @Override
        public int length() {
            return 0;
        }

        @Override
        public char charAt(int index) {
            return '\u0000';
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return "";
        }

        @Override
        public String toString() {
            return "";
        }

        public int hashCode() {
            return Objects.hashCode(this.getClass().getName());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj != null && this.getClass() == obj.getClass();
        }
    }
}

