/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonMissingFieldException;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.json.SerializationContext;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.things.FeatureProperties;
import org.eclipse.ditto.model.things.ThingsModelFactory;

@Immutable
final class NullFeatureProperties
implements FeatureProperties {
    private final JsonObject wrapped = JsonFactory.nullObject();

    private NullFeatureProperties() {
    }

    public static FeatureProperties newInstance() {
        return new NullFeatureProperties();
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isInt() {
        return false;
    }

    public boolean isLong() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isObject() {
        return true;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isNull() {
        return true;
    }

    public boolean asBoolean() {
        return this.wrapped.asBoolean();
    }

    public int asInt() {
        return this.wrapped.asInt();
    }

    public long asLong() {
        return this.wrapped.asLong();
    }

    public double asDouble() {
        return this.wrapped.asDouble();
    }

    public String asString() {
        return this.wrapped.asString();
    }

    public JsonObject asObject() {
        return this;
    }

    public JsonArray asArray() {
        return this.wrapped.asArray();
    }

    @Override
    public FeatureProperties setValue(CharSequence key, int value) {
        return ThingsModelFactory.newFeaturePropertiesBuilder().set(key, value).build();
    }

    @Override
    public FeatureProperties setValue(CharSequence key, long value) {
        return ThingsModelFactory.newFeaturePropertiesBuilder().set(key, value).build();
    }

    @Override
    public FeatureProperties setValue(CharSequence key, double value) {
        return ThingsModelFactory.newFeaturePropertiesBuilder().set(key, value).build();
    }

    @Override
    public FeatureProperties setValue(CharSequence key, boolean value) {
        return ThingsModelFactory.newFeaturePropertiesBuilder().set(key, value).build();
    }

    @Override
    public FeatureProperties setValue(CharSequence key, String value) {
        return ThingsModelFactory.newFeaturePropertiesBuilder().set(key, value).build();
    }

    @Override
    public FeatureProperties setValue(CharSequence key, JsonValue value) {
        return ThingsModelFactory.newFeaturePropertiesBuilder().set(key, value).build();
    }

    public <T> JsonObject set(JsonFieldDefinition<T> fieldDefinition, @Nullable T value) {
        return ThingsModelFactory.newFeaturePropertiesBuilder().set(fieldDefinition, value).build();
    }

    @Override
    public FeatureProperties set(JsonField field) {
        return ThingsModelFactory.newFeaturePropertiesBuilder().set(field).build();
    }

    @Override
    public FeatureProperties setAll(Iterable<JsonField> jsonFields) {
        return ThingsModelFactory.newFeaturePropertiesBuilder().setAll((Iterable)jsonFields).build();
    }

    public boolean contains(CharSequence key) {
        return false;
    }

    public JsonObject get(JsonPointer pointer) {
        return this;
    }

    public JsonObject get(JsonFieldDefinition fieldDefinition) {
        return this;
    }

    public Optional<JsonValue> getValue(CharSequence name) {
        return Optional.empty();
    }

    public <T> Optional<T> getValue(JsonFieldDefinition<T> fieldDefinition) {
        return Optional.empty();
    }

    public <T> T getValueOrThrow(JsonFieldDefinition<T> fieldDefinition) {
        throw new JsonMissingFieldException((CharSequence)fieldDefinition.getPointer());
    }

    public JsonObject get(JsonFieldSelector fieldSelector) {
        return this;
    }

    @Override
    public FeatureProperties remove(CharSequence key) {
        return this;
    }

    public List<JsonKey> getKeys() {
        return Collections.emptyList();
    }

    public Optional<JsonField> getField(CharSequence key) {
        return Optional.empty();
    }

    public Iterator<JsonField> iterator() {
        return Collections.emptyIterator();
    }

    public boolean isEmpty() {
        return true;
    }

    public int getSize() {
        return 0;
    }

    public Stream<JsonField> stream() {
        return Stream.empty();
    }

    public JsonObject toJson() {
        return this.wrapped;
    }

    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        return this.wrapped;
    }

    public int hashCode() {
        return Objects.hash(this.wrapped);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NullFeatureProperties other = (NullFeatureProperties)o;
        return Objects.equals(this.wrapped, other.wrapped);
    }

    public String toString() {
        return this.wrapped.toString();
    }

    public void writeValue(SerializationContext serializationContext) throws IOException {
        JsonFactory.nullLiteral().writeValue(serializationContext);
    }

    public long getUpperBoundForStringSize() {
        return JsonFactory.nullLiteral().getUpperBoundForStringSize();
    }
}

