/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.things.Feature;
import org.eclipse.ditto.model.things.FeatureDefinition;
import org.eclipse.ditto.model.things.FeatureProperties;
import org.eclipse.ditto.model.things.Features;
import org.eclipse.ditto.model.things.ThingsModelFactory;

@Immutable
final class NullFeatures
implements Features {
    private NullFeatures() {
    }

    public static NullFeatures newInstance() {
        return new NullFeatures();
    }

    private static void checkFeatureId(CharSequence featureId) {
        ConditionChecker.checkNotNull((Object)featureId, (String)"Feature ID");
    }

    @Override
    public Optional<Feature> getFeature(String featureId) {
        NullFeatures.checkFeatureId(featureId);
        return Optional.empty();
    }

    @Override
    public Features setFeature(Feature feature) {
        return ThingsModelFactory.newFeatures(feature, new Feature[0]);
    }

    @Override
    public Features removeFeature(String featureId) {
        NullFeatures.checkFeatureId(featureId);
        return this;
    }

    @Override
    public Features setDefinition(String featureId, FeatureDefinition definition) {
        NullFeatures.checkFeatureId(featureId);
        ConditionChecker.checkNotNull((Object)definition, (String)"definition to be set");
        return this;
    }

    @Override
    public Features removeDefinition(String featureId) {
        NullFeatures.checkFeatureId(featureId);
        return this;
    }

    @Override
    public Features setProperties(String featureId, FeatureProperties properties) {
        NullFeatures.checkFeatureId(featureId);
        ConditionChecker.checkNotNull((Object)properties, (String)"properties to be set");
        return this;
    }

    @Override
    public Features removeProperties(String featureId) {
        NullFeatures.checkFeatureId(featureId);
        return this;
    }

    @Override
    public Features setProperty(String featureId, JsonPointer propertyPath, JsonValue propertyValue) {
        NullFeatures.checkFeatureId(featureId);
        ConditionChecker.checkNotNull((Object)propertyPath, (String)"JSON pointer to the property to be set");
        ConditionChecker.checkNotNull((Object)propertyValue, (String)"value of the property to be set");
        return this;
    }

    @Override
    public Features removeProperty(String featureId, JsonPointer propertyPath) {
        NullFeatures.checkFeatureId(featureId);
        ConditionChecker.checkNotNull((Object)propertyPath, (String)"JSON pointer to the property to be removed");
        return this;
    }

    @Override
    public Features setDesiredProperties(CharSequence featureId, FeatureProperties desiredProperties) {
        NullFeatures.checkFeatureId(featureId);
        ConditionChecker.checkNotNull((Object)desiredProperties, (String)"desiredProperties");
        return this;
    }

    @Override
    public Features removeDesiredProperties(CharSequence featureId) {
        NullFeatures.checkFeatureId(featureId);
        return this;
    }

    @Override
    public Features setDesiredProperty(CharSequence featureId, JsonPointer desiredPropertyPath, JsonValue desiredPropertyValue) {
        NullFeatures.checkFeatureId(featureId);
        ConditionChecker.checkNotNull((Object)desiredPropertyPath, (String)"desiredPropertyPath");
        ConditionChecker.checkNotNull((Object)desiredPropertyValue, (String)"desiredPropertyValue");
        return this;
    }

    @Override
    public Features removeDesiredProperty(CharSequence featureId, JsonPointer desiredPropertyPath) {
        NullFeatures.checkFeatureId(featureId);
        ConditionChecker.checkNotNull((Object)desiredPropertyPath, (String)"desiredPropertyPath");
        return this;
    }

    @Override
    public boolean isNull() {
        return true;
    }

    @Override
    public int getSize() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Stream<Feature> stream() {
        return Stream.empty();
    }

    @Override
    public Iterator<Feature> iterator() {
        return Collections.emptyIterator();
    }

    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        return JsonFactory.nullObject();
    }

    public int hashCode() {
        return Objects.hashCode(this.getClass().getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj != null && this.getClass() == obj.getClass();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " []";
    }
}

