/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableException;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.things.ThingException;
import org.eclipse.ditto.model.things.ThingId;

@JsonParsableException(errorCode="things:policy.id.missing")
@Immutable
public final class PolicyIdMissingException
extends DittoRuntimeException
implements ThingException {
    public static final String ERROR_CODE = "things:policy.id.missing";
    private static final String MESSAGE_TEMPLATE_UPDATE = "The schema version of the Thing with ID ''{0}'' does not allow an update on schema version ''{1}'' without providing a policy id";
    private static final String DEFAULT_DESCRIPTION_UPDATE = "When updating a schema version 1 Thing using a higher schema version API, you need to add a policyId. Be aware that this will convert the Thing to the higher schema version, thus removing all ACL information from it.";
    private static final String MESSAGE_TEMPLATE_CREATE = "The schema version of the Thing with ID ''{0}'' (''{1}'') does not allow creation without providing a policy id";
    private static final String DEFAULT_DESCRIPTION_CREATE = "You need to specify a policy id.";
    private static final String DEFAULT_DESCRIPTION_GENERIC = "Either you need to specific a PolicyId or when updating a schema version 1 Thing using a higher schema version API, you need to add a policyId. Be aware that this will convert the Thing to the higher schema version, thus removing all ACL information from it.";
    private static final long serialVersionUID = -2640894758584381867L;

    private PolicyIdMissingException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, message, description, cause, href);
    }

    public static PolicyIdMissingException fromThingIdOnUpdate(ThingId thingId, DittoHeaders dittoHeaders) {
        JsonSchemaVersion schemaVersion = dittoHeaders.getSchemaVersion().orElse(JsonSchemaVersion.LATEST);
        return (PolicyIdMissingException)new Builder(thingId, schemaVersion, MESSAGE_TEMPLATE_UPDATE, DEFAULT_DESCRIPTION_UPDATE).dittoHeaders(dittoHeaders).build();
    }

    public static PolicyIdMissingException fromThingIdOnCreate(ThingId thingId, DittoHeaders dittoHeaders) {
        JsonSchemaVersion schemaVersion = dittoHeaders.getSchemaVersion().orElse(JsonSchemaVersion.LATEST);
        return (PolicyIdMissingException)new Builder(thingId, schemaVersion, MESSAGE_TEMPLATE_CREATE, DEFAULT_DESCRIPTION_CREATE).dittoHeaders(dittoHeaders).build();
    }

    public static PolicyIdMissingException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (PolicyIdMissingException)DittoRuntimeException.fromJson((JsonObject)jsonObject, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public JsonSchemaVersion[] getSupportedSchemaVersions() {
        return new JsonSchemaVersion[]{JsonSchemaVersion.V_1};
    }

    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<PolicyIdMissingException> {
        private Builder() {
            this.description(PolicyIdMissingException.DEFAULT_DESCRIPTION_GENERIC);
        }

        private Builder(ThingId thingId, JsonSchemaVersion version, String messageTemplate, String description) {
            this();
            this.message(MessageFormat.format(messageTemplate, String.valueOf((Object)thingId), version.toInt()));
            this.description(description);
        }

        protected PolicyIdMissingException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new PolicyIdMissingException(dittoHeaders, message, description, cause, href);
        }
    }
}

