/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.auth.AuthorizationSubject;
import org.eclipse.ditto.model.base.entity.Entity;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.PolicyId;
import org.eclipse.ditto.model.things.AccessControlList;
import org.eclipse.ditto.model.things.AclEntry;
import org.eclipse.ditto.model.things.Attributes;
import org.eclipse.ditto.model.things.Feature;
import org.eclipse.ditto.model.things.FeatureDefinition;
import org.eclipse.ditto.model.things.FeatureProperties;
import org.eclipse.ditto.model.things.Features;
import org.eclipse.ditto.model.things.Permission;
import org.eclipse.ditto.model.things.Permissions;
import org.eclipse.ditto.model.things.ThingBuilder;
import org.eclipse.ditto.model.things.ThingDefinition;
import org.eclipse.ditto.model.things.ThingId;
import org.eclipse.ditto.model.things.ThingLifecycle;
import org.eclipse.ditto.model.things.ThingRevision;
import org.eclipse.ditto.model.things.ThingsModelFactory;

@Immutable
public interface Thing
extends Entity<ThingRevision> {
    @Deprecated
    public static final Permissions MIN_REQUIRED_PERMISSIONS = ThingsModelFactory.newUnmodifiablePermissions(Permission.READ, Permission.WRITE, Permission.ADMINISTRATE);

    public static ThingBuilder.FromScratch newBuilder() {
        return ThingsModelFactory.newThingBuilder();
    }

    default public ThingBuilder.FromCopy toBuilder() {
        return ThingsModelFactory.newThingBuilder(this);
    }

    default public JsonSchemaVersion getImplementedSchemaVersion() {
        return this.getAccessControlList().isPresent() && !this.getPolicyEntityId().isPresent() ? JsonSchemaVersion.V_1 : JsonSchemaVersion.LATEST;
    }

    public Optional<String> getNamespace();

    public Optional<Attributes> getAttributes();

    public Thing setAttributes(@Nullable Attributes var1);

    public Thing removeAttributes();

    public Optional<ThingId> getEntityId();

    default public Thing setAttribute(CharSequence attributePath, JsonValue attributeValue) {
        return this.setAttribute(JsonPointer.of((CharSequence)attributePath), attributeValue);
    }

    default public Thing setAttribute(CharSequence attributePath, boolean attributeValue) {
        return this.setAttribute(JsonPointer.of((CharSequence)attributePath), JsonValue.of((boolean)attributeValue));
    }

    default public Thing setAttribute(CharSequence attributePath, int attributeValue) {
        return this.setAttribute(JsonPointer.of((CharSequence)attributePath), JsonValue.of((int)attributeValue));
    }

    default public Thing setAttribute(CharSequence attributePath, long attributeValue) {
        return this.setAttribute(JsonPointer.of((CharSequence)attributePath), JsonValue.of((long)attributeValue));
    }

    default public Thing setAttribute(CharSequence attributePath, double attributeValue) {
        return this.setAttribute(JsonPointer.of((CharSequence)attributePath), JsonValue.of((double)attributeValue));
    }

    default public Thing setAttribute(CharSequence attributePath, String attributeValue) {
        return this.setAttribute(JsonPointer.of((CharSequence)attributePath), JsonValue.of((String)attributeValue));
    }

    public Thing setAttribute(JsonPointer var1, JsonValue var2);

    default public Thing removeAttribute(CharSequence attributePath) {
        return this.removeAttribute(JsonPointer.of((CharSequence)attributePath));
    }

    public Thing removeAttribute(JsonPointer var1);

    public Optional<ThingDefinition> getDefinition();

    public Thing setDefinition(@Nullable CharSequence var1);

    public Thing removeDefinition();

    public Thing setFeatureDefinition(String var1, FeatureDefinition var2);

    public Thing removeFeatureDefinition(String var1);

    public Thing setFeatureProperties(String var1, FeatureProperties var2);

    default public Thing setFeatureProperty(String featureId, CharSequence propertyPath, JsonValue propertyValue) {
        return this.setFeatureProperty(featureId, JsonPointer.of((CharSequence)propertyPath), propertyValue);
    }

    default public Thing setFeatureProperty(String featureId, CharSequence propertyPath, boolean propertyValue) {
        return this.setFeatureProperty(featureId, JsonPointer.of((CharSequence)propertyPath), JsonValue.of((boolean)propertyValue));
    }

    default public Thing setFeatureProperty(String featureId, CharSequence propertyPath, int propertyValue) {
        return this.setFeatureProperty(featureId, JsonPointer.of((CharSequence)propertyPath), JsonValue.of((int)propertyValue));
    }

    default public Thing setFeatureProperty(String featureId, CharSequence propertyPath, long propertyValue) {
        return this.setFeatureProperty(featureId, JsonPointer.of((CharSequence)propertyPath), JsonValue.of((long)propertyValue));
    }

    default public Thing setFeatureProperty(String featureId, CharSequence propertyPath, double propertyValue) {
        return this.setFeatureProperty(featureId, JsonPointer.of((CharSequence)propertyPath), JsonValue.of((double)propertyValue));
    }

    default public Thing setFeatureProperty(String featureId, CharSequence propertyPath, String propertyValue) {
        return this.setFeatureProperty(featureId, JsonPointer.of((CharSequence)propertyPath), JsonValue.of((String)propertyValue));
    }

    public Thing setFeatureProperty(String var1, JsonPointer var2, JsonValue var3);

    public Thing removeFeatureProperties(String var1);

    default public Thing removeFeatureProperty(String featureId, CharSequence propertyPath) {
        return this.removeFeatureProperty(featureId, JsonPointer.of((CharSequence)propertyPath));
    }

    public Thing removeFeatureProperty(String var1, JsonPointer var2);

    public Thing setFeatureDesiredProperties(CharSequence var1, FeatureProperties var2);

    default public Thing setFeatureDesiredProperty(CharSequence featureId, CharSequence desiredPropertyPath, JsonValue desiredPropertyValue) {
        return this.setFeatureDesiredProperty(featureId, JsonPointer.of((CharSequence)desiredPropertyPath), desiredPropertyValue);
    }

    default public Thing setFeatureDesiredProperty(CharSequence featureId, CharSequence desiredPropertyPath, boolean desiredPropertyValue) {
        return this.setFeatureDesiredProperty(featureId, JsonPointer.of((CharSequence)desiredPropertyPath), JsonValue.of((boolean)desiredPropertyValue));
    }

    default public Thing setFeatureDesiredProperty(CharSequence featureId, CharSequence desiredPropertyPath, int desiredPropertyValue) {
        return this.setFeatureDesiredProperty(featureId, JsonPointer.of((CharSequence)desiredPropertyPath), JsonValue.of((int)desiredPropertyValue));
    }

    default public Thing setFeatureDesiredProperty(CharSequence featureId, CharSequence desiredPropertyPath, long desiredPropertyValue) {
        return this.setFeatureDesiredProperty(featureId, JsonPointer.of((CharSequence)desiredPropertyPath), JsonValue.of((long)desiredPropertyValue));
    }

    default public Thing setFeatureDesiredProperty(CharSequence featureId, CharSequence desiredPropertyPath, double desiredPropertyValue) {
        return this.setFeatureDesiredProperty(featureId, JsonPointer.of((CharSequence)desiredPropertyPath), JsonValue.of((double)desiredPropertyValue));
    }

    default public Thing setFeatureDesiredProperty(CharSequence featureId, CharSequence desiredPropertyPath, String desiredPropertyValue) {
        return this.setFeatureDesiredProperty(featureId, JsonPointer.of((CharSequence)desiredPropertyPath), JsonValue.of((String)desiredPropertyValue));
    }

    public Thing setFeatureDesiredProperty(CharSequence var1, JsonPointer var2, JsonValue var3);

    public Thing removeFeatureDesiredProperties(CharSequence var1);

    default public Thing removeFeatureDesiredProperty(CharSequence featureId, CharSequence propertyPath) {
        return this.removeFeatureDesiredProperty(featureId, JsonPointer.of((CharSequence)propertyPath));
    }

    public Thing removeFeatureDesiredProperty(CharSequence var1, JsonPointer var2);

    public Optional<ThingLifecycle> getLifecycle();

    public Thing setLifecycle(ThingLifecycle var1);

    default public boolean hasLifecycle(ThingLifecycle lifecycle) {
        return this.getLifecycle().filter(actualLifecycle -> Objects.equals(actualLifecycle, (Object)lifecycle)).isPresent();
    }

    @Deprecated
    public Optional<AccessControlList> getAccessControlList();

    @Deprecated
    public Thing setAccessControlList(AccessControlList var1);

    @Deprecated
    public Thing setAclEntry(AclEntry var1);

    @Deprecated
    public Thing removeAllPermissionsOf(AuthorizationSubject var1);

    @Deprecated
    default public Optional<String> getPolicyId() {
        return this.getPolicyEntityId().map(String::valueOf);
    }

    @Deprecated
    default public Thing setPolicyId(@Nullable String policyId) {
        return this.setPolicyId(policyId == null ? null : PolicyId.of((CharSequence)policyId));
    }

    public Thing setPolicyId(@Nullable PolicyId var1);

    public Optional<PolicyId> getPolicyEntityId();

    public Optional<Features> getFeatures();

    public Thing setFeatures(@Nullable Features var1);

    public Thing removeFeatures();

    public Thing setFeature(Feature var1);

    public Thing removeFeature(String var1);

    @Deprecated
    default public void validate(DittoHeaders headers) {
    }

    @Immutable
    public static final class JsonFields {
        public static final JsonFieldDefinition<Integer> SCHEMA_VERSION = JsonFactory.newIntFieldDefinition((CharSequence)JsonSchemaVersion.getJsonKey(), (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.SPECIAL, FieldType.HIDDEN, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> LIFECYCLE = JsonFactory.newStringFieldDefinition((CharSequence)"__lifecycle", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.SPECIAL, FieldType.HIDDEN, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> NAMESPACE = JsonFactory.newStringFieldDefinition((CharSequence)"_namespace", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.SPECIAL, FieldType.HIDDEN, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<Long> REVISION = JsonFactory.newLongFieldDefinition((CharSequence)"_revision", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.SPECIAL, FieldType.HIDDEN, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> MODIFIED = JsonFactory.newStringFieldDefinition((CharSequence)"_modified", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.SPECIAL, FieldType.HIDDEN, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> CREATED = JsonFactory.newStringFieldDefinition((CharSequence)"_created", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.SPECIAL, FieldType.HIDDEN, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> ID = JsonFactory.newStringFieldDefinition((CharSequence)"thingId", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonObject> ACL = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"acl", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1});
        public static final JsonFieldDefinition<String> POLICY_ID = JsonFactory.newStringFieldDefinition((CharSequence)"policyId", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonValue> DEFINITION = JsonFactory.newJsonValueFieldDefinition((CharSequence)"definition", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonObject> ATTRIBUTES = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"attributes", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonObject> FEATURES = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"features", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonObject> METADATA = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"_metadata", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.SPECIAL, FieldType.HIDDEN, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});

        private JsonFields() {
            throw new AssertionError();
        }
    }
}

