/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonParseOptions;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.model.things.InvalidThingFieldSelectionException;

public final class ThingFieldSelector
implements JsonFieldSelector {
    private static final JsonParseOptions JSON_PARSE_OPTIONS = JsonParseOptions.newBuilder().withoutUrlDecoding().build();
    static final List<String> SELECTABLE_FIELDS = Arrays.asList("thingId", "policyId", "definition", "_namespace", "_revision", "_created", "_modified", "_metadata", "_policy", "features(/[^,]+)?", "attributes(/[^,]+)?");
    private static final String KNOWN_FIELDS_REGEX = "/?(" + String.join((CharSequence)"|", SELECTABLE_FIELDS) + ")";
    private static final String FIELD_SELECTION_REGEX = "^" + KNOWN_FIELDS_REGEX + "(," + KNOWN_FIELDS_REGEX + ")*$";
    private static final Pattern FIELD_SELECTION_PATTERN = Pattern.compile(FIELD_SELECTION_REGEX);
    private final JsonFieldSelector jsonFieldSelector;

    private ThingFieldSelector(JsonFieldSelector jsonFieldSelector) {
        this.jsonFieldSelector = jsonFieldSelector;
    }

    public static ThingFieldSelector fromJsonFieldSelector(JsonFieldSelector jsonFieldSelector) {
        if (jsonFieldSelector instanceof ThingFieldSelector) {
            return (ThingFieldSelector)jsonFieldSelector;
        }
        if (jsonFieldSelector == null) {
            throw InvalidThingFieldSelectionException.forExtraFieldSelectionString(null);
        }
        if (FIELD_SELECTION_PATTERN.matcher(jsonFieldSelector.toString()).matches()) {
            return new ThingFieldSelector(jsonFieldSelector);
        }
        throw InvalidThingFieldSelectionException.forExtraFieldSelectionString(jsonFieldSelector.toString());
    }

    public static ThingFieldSelector fromString(String selectionString) {
        if (selectionString == null) {
            throw InvalidThingFieldSelectionException.forExtraFieldSelectionString(null);
        }
        if (FIELD_SELECTION_PATTERN.matcher(selectionString).matches()) {
            return new ThingFieldSelector(JsonFactory.newFieldSelector((String)selectionString, (JsonParseOptions)JSON_PARSE_OPTIONS));
        }
        throw InvalidThingFieldSelectionException.forExtraFieldSelectionString(selectionString);
    }

    public JsonFieldSelector getJsonFieldSelector() {
        return this.jsonFieldSelector;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThingFieldSelector that = (ThingFieldSelector)o;
        return Objects.equals(this.jsonFieldSelector, that.jsonFieldSelector);
    }

    public int hashCode() {
        return Objects.hash(this.jsonFieldSelector);
    }

    public Set<JsonPointer> getPointers() {
        return this.jsonFieldSelector.getPointers();
    }

    public int getSize() {
        return this.jsonFieldSelector.getSize();
    }

    public boolean isEmpty() {
        return this.jsonFieldSelector.isEmpty();
    }

    public String toString() {
        return this.jsonFieldSelector.toString();
    }

    public Iterator<JsonPointer> iterator() {
        return this.jsonFieldSelector.iterator();
    }
}

