/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.remotedev;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.IoUtil;
import org.eclipse.jkube.kit.remotedev.LocalService;
import org.eclipse.jkube.kit.remotedev.RemoteDevelopmentConfig;

public class RemoteDevelopmentContext {
    private static final String REMOTE_DEV_PROPERTIES_FILE = "/META-INF/jkube/remote-dev.properties";
    private final KitLogger logger;
    private final KubernetesClient kubernetesClient;
    private final RemoteDevelopmentConfig remoteDevelopmentConfig;
    private final AtomicInteger sshPort;
    private final AtomicReference<String> user;
    private final KeyPair clientKeys;
    private final String sshRsaPublicKey;
    private final Properties properties;
    private final Map<LocalService, Service> managedServices;
    private final UUID sessionID;

    public RemoteDevelopmentContext(KitLogger kitLogger, KubernetesClient kubernetesClient, RemoteDevelopmentConfig remoteDevelopmentConfig) {
        this.logger = Objects.requireNonNull(kitLogger, "KitLogger is required");
        this.kubernetesClient = Objects.requireNonNull(kubernetesClient, "KubernetesClient is required");
        this.remoteDevelopmentConfig = Objects.requireNonNull(remoteDevelopmentConfig, "JKube's remoteDevelopmentConfig is required and should contain the definitions for local and remote services");
        this.sshPort = new AtomicInteger(-1);
        this.user = new AtomicReference();
        this.clientKeys = RemoteDevelopmentContext.initClientKeys();
        this.sshRsaPublicKey = RemoteDevelopmentContext.initSShRsaPublicKey(this.clientKeys);
        this.properties = new Properties();
        this.managedServices = new ConcurrentHashMap<LocalService, Service>();
        this.sessionID = UUID.randomUUID();
        try {
            this.properties.load(RemoteDevelopmentContext.class.getResourceAsStream(REMOTE_DEV_PROPERTIES_FILE));
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to load remote development properties", ex);
        }
    }

    RemoteDevelopmentConfig getRemoteDevelopmentConfig() {
        return this.remoteDevelopmentConfig;
    }

    void reset() {
        this.sshPort.set(-1);
        this.user.set(null);
    }

    int getSshPort() {
        return this.sshPort.updateAndGet(v -> v == -1 ? IoUtil.getFreeRandomPort() : v);
    }

    String getUser() {
        return this.user.get();
    }

    void setUser(String user) {
        this.user.set(user);
    }

    KeyPair getClientKeys() {
        return this.clientKeys;
    }

    String getRemoteDevPodImage() {
        return this.properties.getProperty("jkube.remote-dev.pod.container.image");
    }

    int getRemoteDevPodPort() {
        return Integer.parseInt(this.properties.getProperty("jkube.remote-dev.pod.container.port"));
    }

    private static KeyPair initClientKeys() {
        try {
            KeyPairGenerator kgp = KeyPairGenerator.getInstance("RSA");
            kgp.initialize(2048);
            return kgp.generateKeyPair();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException("RSA algorithm not available", ex);
        }
    }

    /*
     * Exception decompiling
     */
    private static String initSShRsaPublicKey(KeyPair rsaKeyPair) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public KitLogger getLogger() {
        return this.logger;
    }

    public KubernetesClient getKubernetesClient() {
        return this.kubernetesClient;
    }

    public String getSshRsaPublicKey() {
        return this.sshRsaPublicKey;
    }

    public Map<LocalService, Service> getManagedServices() {
        return this.managedServices;
    }

    public UUID getSessionID() {
        return this.sessionID;
    }
}

