/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.resource.service;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.ResourceFileType;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.common.util.ResourceClassifier;
import org.eclipse.jkube.kit.common.util.ValidationUtil;
import org.eclipse.jkube.kit.config.resource.EnricherManager;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.config.resource.ProcessorConfig;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.config.resource.ResourceService;
import org.eclipse.jkube.kit.config.resource.ResourceServiceConfig;
import org.eclipse.jkube.kit.enricher.api.util.KubernetesResourceFragments;
import org.eclipse.jkube.kit.profile.Profile;
import org.eclipse.jkube.kit.profile.ProfileUtil;
import org.eclipse.jkube.kit.resource.service.TemplateUtil;
import org.eclipse.jkube.kit.resource.service.WriteUtil;

public class DefaultResourceService
implements ResourceService {
    private final ResourceServiceConfig resourceServiceConfig;

    public DefaultResourceService(ResourceServiceConfig resourceServiceConfig) {
        this.resourceServiceConfig = resourceServiceConfig;
    }

    public KubernetesList generateResources(PlatformMode platformMode, EnricherManager enricherManager, KitLogger log) throws IOException {
        return ((KubernetesListBuilder)this.generateAppResources(platformMode, enricherManager, log).addAllToItems(this.generateProfiledResourcesFromSubdirectories(platformMode, enricherManager))).build();
    }

    public File writeResources(KubernetesList resources, ResourceClassifier classifier, KitLogger log) throws IOException {
        File targetDir = this.resourceServiceConfig.getTargetDir();
        ResourceFileType resourceFileType = this.resourceServiceConfig.getResourceFileType();
        File resourceFileBase = new File(targetDir, classifier.getValue());
        File file = WriteUtil.writeResourcesIndividualAndComposite(resources, resourceFileBase, resourceFileType, log);
        if (this.resourceServiceConfig.isInterpolateTemplateParameters()) {
            TemplateUtil.interpolateTemplateVariables(resources, file);
        }
        return file;
    }

    private KubernetesListBuilder generateAppResources(PlatformMode platformMode, EnricherManager enricherManager, KitLogger log) throws IOException {
        ResourceConfig resourceConfig = this.resourceServiceConfig.getResourceConfig();
        try {
            File[] resourceFiles = KubernetesHelper.listResourceFragments((List)(resourceConfig != null ? resourceConfig.getRemotes() : null), (KitLogger)log, (List)this.resourceServiceConfig.getResourceDirs());
            this.resourceServiceConfig.getResourceDirs().forEach(resourceDir -> log.info("Using resource templates from %s", new Object[]{resourceDir}));
            File[] processedResource = this.processResourceFiles(resourceFiles);
            KubernetesListBuilder builder = this.processResourceFragments(processedResource);
            enricherManager.createDefaultResources(platformMode, builder);
            enricherManager.enrich(platformMode, builder);
            return builder;
        }
        catch (ConstraintViolationException e) {
            String message = ValidationUtil.createValidationMessage((Set)e.getConstraintViolations());
            log.error("ConstraintViolationException: %s", new Object[]{message});
            throw new IOException(message, e);
        }
    }

    private KubernetesListBuilder processResourceFragments(File[] resourceFiles) throws IOException {
        KubernetesListBuilder builder = new KubernetesListBuilder();
        if (resourceFiles != null && resourceFiles.length > 0) {
            builder.addAllToItems((Collection)this.readResourceFragments(resourceFiles).buildItems());
        }
        return builder;
    }

    private List<HasMetadata> generateProfiledResourcesFromSubdirectories(PlatformMode platformMode, EnricherManager enricherManager) throws IOException {
        ArrayList<HasMetadata> ret = new ArrayList<HasMetadata>();
        List resourceDirs = this.resourceServiceConfig.getResourceDirs();
        for (File resourceDir : resourceDirs) {
            File[] profileDirs = resourceDir.listFiles(File::isDirectory);
            if (profileDirs == null) continue;
            for (File profileDir : profileDirs) {
                Profile foundProfile = ProfileUtil.findProfile((String)profileDir.getName(), (File[])new File[]{resourceDir});
                ProcessorConfig enricherConfig = foundProfile.getEnricherConfig();
                File[] resourceFiles = KubernetesHelper.listResourceFragments((File)profileDir);
                File[] processedResources = this.processResourceFiles(resourceFiles);
                if (processedResources.length <= 0) continue;
                KubernetesListBuilder profileBuilder = this.readResourceFragments(processedResources);
                enricherManager.createDefaultResources(platformMode, enricherConfig, profileBuilder);
                enricherManager.enrich(platformMode, enricherConfig, profileBuilder);
                ret.addAll(profileBuilder.buildItems());
            }
        }
        return ret;
    }

    private KubernetesListBuilder readResourceFragments(File[] resourceFiles) throws IOException {
        return KubernetesResourceFragments.readResourceFragmentsFrom((File[])resourceFiles);
    }

    private File[] processResourceFiles(File[] resourceFiles) throws IOException {
        if (this.resourceServiceConfig.getResourceFilesProcessor() != null) {
            return this.resourceServiceConfig.getResourceFilesProcessor().processResources(resourceFiles);
        }
        return resourceFiles;
    }
}

