/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.test.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.tycho.test.AbstractTychoIntegrationTest;

public class EnvironmentUtil {
    private static final Properties props = new Properties();
    private static final String WINDOWS_OS = "windows";
    private static final String MAC_OS = "mac os x";
    private static final String MAC_OS_DARWIN = "darwin";
    private static final String LINUX_OS = "linux";
    private static final String OS;

    static synchronized String getProperty(String key) {
        return props.getProperty(key);
    }

    public static boolean isWindows() {
        return OS.startsWith(WINDOWS_OS);
    }

    public static boolean isLinux() {
        return OS.startsWith(LINUX_OS);
    }

    public static boolean isMac() {
        return OS.startsWith(MAC_OS) || OS.startsWith(MAC_OS_DARWIN);
    }

    public static boolean isEclipse32Platform() {
        return new File(EnvironmentUtil.getTargetPlatforn(), "startup.jar").exists();
    }

    public static String getTargetPlatforn() {
        return EnvironmentUtil.getProperty("its-target-platform");
    }

    public static String getTestSettings() {
        String value = EnvironmentUtil.getProperty("its-settings");
        if (value.contains("$")) {
            return null;
        }
        return value;
    }

    public static String getMavenHome() {
        return EnvironmentUtil.getProperty("maven-dir");
    }

    public static String getTychoVersion() {
        return EnvironmentUtil.getProperty("tycho-version");
    }

    public static int getHttpServerPort() {
        String port = EnvironmentUtil.getProperty("server-port");
        return Integer.parseInt(port);
    }

    public static String getLocalRepo() {
        return EnvironmentUtil.getProperty("local-repo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        ClassLoader cl = AbstractTychoIntegrationTest.class.getClassLoader();
        InputStream is = cl.getResourceAsStream("baseTest.properties");
        if (is != null) {
            try {
                try {
                    props.load(is);
                }
                finally {
                    is.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        OS = System.getProperty("os.name").toLowerCase();
    }
}

