/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.test.util;

import java.io.File;
import java.io.IOException;
import org.eclipse.tycho.p2.repository.GAV;
import org.eclipse.tycho.test.util.EnvironmentUtil;

public class LocalMavenRepositoryTool {
    private File localRepo = new File(EnvironmentUtil.getLocalRepo());

    public LocalMavenRepositoryTool() {
        if (!this.localRepo.isDirectory()) {
            throw new IllegalStateException("Local Maven repository does not exist: " + this.localRepo);
        }
    }

    public File getArtifactFile(GAV gav, String classifier, String extension) {
        return this.getArtifactFile(gav.getGroupId(), gav.getArtifactId(), gav.getVersion(), classifier, extension);
    }

    public File getArtifactFile(String groupId, String artifactId, String version, String classifier, String extension) {
        String groupPath = groupId.replace('.', '/');
        String artifactPath = groupPath + '/' + artifactId + '/' + version;
        String artifactName = artifactId + "-" + version + (classifier == null ? "" : "-" + classifier) + "." + extension;
        return new File(this.localRepo, artifactPath + '/' + artifactName);
    }

    public void hideAllLocalTychoArtifacts() throws IOException {
        boolean success;
        File listOfTychoBuiltArtifact = new File(this.localRepo, ".meta/p2-local-metadata.properties");
        if (listOfTychoBuiltArtifact.exists() && !(success = listOfTychoBuiltArtifact.delete())) {
            throw new IOException("Could not delete " + listOfTychoBuiltArtifact);
        }
    }
}

