/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.test;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.maven.it.Verifier;
import org.apache.maven.it.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.tycho.test.util.EnvironmentUtil;
import org.junit.Assert;
import org.osgi.framework.Version;

public abstract class AbstractTychoIntegrationTest {
    protected File getBasedir(String test) throws IOException {
        File src = new File("projects", test).getCanonicalFile();
        File dst = new File("target/projects", test).getCanonicalFile();
        if (dst.isDirectory()) {
            FileUtils.deleteDirectory((File)dst);
        } else if (dst.isFile() && !dst.delete()) {
            throw new IOException("Can't delete file " + dst.toString());
        }
        FileUtils.copyDirectoryStructure((File)src, (File)dst);
        return dst;
    }

    protected Verifier getVerifier(String test, boolean setTargetPlatform) throws Exception {
        return this.getVerifier(test, setTargetPlatform, AbstractTychoIntegrationTest.getSettings());
    }

    protected Verifier getVerifier(String test, boolean setTargetPlatform, File userSettings) throws Exception {
        System.setProperty("maven.home", this.getMavenHome());
        File testDir = this.getBasedir(test);
        Verifier verifier = new Verifier(testDir.getAbsolutePath());
        verifier.getCliOptions().add("-Dmaven.home=" + this.getMavenHome());
        verifier.getCliOptions().add("-Dtycho-version=" + this.getTychoVersion());
        if (setTargetPlatform) {
            verifier.getCliOptions().add("-Dtycho.targetPlatform=" + this.getTargetPlatforn());
        }
        verifier.getCliOptions().add("-X");
        verifier.getCliOptions().add("-s " + userSettings.getCanonicalPath());
        verifier.getVerifierProperties().put("use.mavenRepoLocal", "true");
        verifier.setLocalRepo(EnvironmentUtil.getLocalRepo());
        String customOptions = System.getProperty("it.cliOptions");
        if (customOptions != null && customOptions.trim().length() > 0) {
            verifier.getCliOptions().add(customOptions);
        }
        String m2eState = System.getProperty("m2eclipse.workspace.state");
        String m2eResolver = System.getProperty("m2eclipse.workspace.resolver");
        if (m2eState != null && m2eResolver != null) {
            verifier.getVerifierProperties().put("m2eclipse.workspace.state", m2eState);
        }
        return verifier;
    }

    protected Verifier getVerifier(String test) throws Exception {
        return this.getVerifier(test, true);
    }

    protected String getTargetPlatforn() {
        return EnvironmentUtil.getTargetPlatforn();
    }

    private static File getSettings() {
        String systemValue = System.getProperty("tycho.testSettings");
        if (systemValue != null) {
            return new File(systemValue);
        }
        String commandLineValue = EnvironmentUtil.getTestSettings();
        if (commandLineValue != null) {
            return new File(commandLineValue);
        }
        return new File("settings.xml");
    }

    protected String getMavenHome() {
        return EnvironmentUtil.getMavenHome();
    }

    protected String getTychoVersion() {
        return EnvironmentUtil.getTychoVersion();
    }

    protected void assertFileExists(File targetdir, String pattern) {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(targetdir);
        ds.setIncludes(new String[]{pattern});
        ds.scan();
        Assert.assertEquals((String)(targetdir.getAbsolutePath() + "/" + pattern), (long)1L, (long)ds.getIncludedFiles().length);
        Assert.assertTrue((String)(targetdir.getAbsolutePath() + "/" + pattern), (boolean)new File(targetdir, ds.getIncludedFiles()[0]).canRead());
    }

    protected void assertDirectoryExists(File targetdir, String pattern) {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(targetdir);
        ds.setIncludes(new String[]{pattern});
        ds.scan();
        Assert.assertEquals((String)(targetdir.getAbsolutePath() + "/" + pattern), (long)1L, (long)ds.getIncludedDirectories().length);
        Assert.assertTrue((String)(targetdir.getAbsolutePath() + "/" + pattern), (boolean)new File(targetdir, ds.getIncludedDirectories()[0]).exists());
    }

    protected void assertFileDoesNotExist(File targetdir, String pattern) {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(targetdir);
        ds.setIncludes(new String[]{pattern});
        ds.scan();
        Assert.assertEquals((String)(targetdir.getAbsolutePath() + "/" + pattern), (long)0L, (long)ds.getIncludedFiles().length);
    }

    protected String toURI(File file) throws IOException {
        return file.getCanonicalFile().toURI().normalize().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeStringToFile(File iniFile, String string) throws IOException {
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(iniFile));
        try {
            IOUtil.copy((String)string, (OutputStream)os);
        }
        finally {
            IOUtil.close((OutputStream)os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StringBuffer readFileToString(File iniFile) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(iniFile));
        try {
            StringWriter buffer = new StringWriter();
            IOUtil.copy((InputStream)is, (Writer)buffer, (String)"UTF-8");
            StringBuffer stringBuffer = buffer.getBuffer();
            return stringBuffer;
        }
        finally {
            IOUtil.close((InputStream)is);
        }
    }

    public static Version getEclipseVersion() {
        String location = EnvironmentUtil.getTargetPlatforn();
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(new File(location, "plugins"));
        ds.setIncludes(new String[]{"org.eclipse.osgi_*.jar"});
        ds.scan();
        String[] files = ds.getIncludedFiles();
        if (files == null || files.length < 1) {
            throw new IllegalStateException("Unable to determine version of the test target platform " + location);
        }
        String version = files[0].substring("org.eclipse.osgi_".length(), files[0].length() - ".jar".length());
        return Version.parseVersion((String)version);
    }
}

