/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.test.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.tycho.locking.facade.FileLockService;
import org.eclipse.tycho.locking.facade.FileLocker;
import org.eclipse.tycho.test.util.EnvironmentUtil;

@Component(role=LocalMavenRepositoryTool.class)
public class LocalMavenRepositoryTool {
    private File localRepo = new File(EnvironmentUtil.getLocalRepo());
    @Requirement
    private FileLockService fileLockService;

    public LocalMavenRepositoryTool() {
        if (!this.localRepo.isDirectory()) {
            throw new IllegalStateException("Local Maven repository does not exist: " + this.localRepo);
        }
    }

    public File getArtifactFile(String groupId, String artifactId, String version, String classifier, String extension) {
        String groupPath = groupId.replace('.', '/');
        String artifactPath = groupPath + '/' + artifactId + '/' + version;
        String artifactName = artifactId + "-" + version + (classifier == null ? "" : "-" + classifier) + "." + extension;
        return new File(this.localRepo, artifactPath + '/' + artifactName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLinesFromMetadataIndex(String ... linesToBeRemoved) throws IOException {
        HashSet<String> toBeRemoved = new HashSet<String>(Arrays.asList(linesToBeRemoved));
        File indexFile = new File(this.localRepo, ".meta/p2-local-metadata.properties");
        FileLocker locker = this.fileLockService.getFileLocker(indexFile);
        locker.lock();
        try {
            ArrayList<String> lines = new ArrayList<String>();
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(indexFile), "UTF-8"));
            try {
                String line = reader.readLine();
                while (line != null) {
                    if (!toBeRemoved.contains(line)) {
                        lines.add(line);
                    }
                    line = reader.readLine();
                }
            }
            finally {
                reader.close();
            }
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(indexFile), "UTF-8");
            try {
                for (String line : lines) {
                    writer.write(line + "\n");
                }
            }
            finally {
                ((Writer)writer).close();
            }
        }
        finally {
            locker.release();
        }
    }
}

