/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.test.util;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.junit.Assert;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2RepositoryTool {
    private final File repoLocation;
    private final File metadataFile;
    private Document contentXml;
    private XPath xPathTool;
    private Pattern strictVersionRangePattern;

    private P2RepositoryTool(File metadataFile) {
        this.repoLocation = metadataFile.getParentFile();
        this.metadataFile = metadataFile;
    }

    public static P2RepositoryTool forEclipseRepositoryModule(File projectRootFolder) {
        File repoLocation = new File(projectRootFolder, "target/repository");
        File contentXml = new File(repoLocation, "content.xml");
        File contentJar = new File(repoLocation, "content.jar");
        if (contentXml.isFile()) {
            return new P2RepositoryTool(contentXml);
        }
        if (contentJar.isFile()) {
            return new P2RepositoryTool(contentJar);
        }
        throw new IllegalStateException("Not an eclipse-repository project, or project has not been built: " + projectRootFolder);
    }

    public File getBundleArtifact(String bundleId, String version) {
        String pathInRepo = "plugins/" + bundleId + "_" + version + ".jar";
        return new File(this.repoLocation, pathInRepo);
    }

    public File getFeatureArtifact(String featureId, String version) {
        String pathInRepo = "features/" + featureId + "_" + version + ".jar";
        return new File(this.repoLocation, pathInRepo);
    }

    public File findFeatureArtifact(final String featureId) {
        File[] matchingFeatures = new File(this.repoLocation, "features").listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(featureId + "_");
            }
        });
        return matchingFeatures[0];
    }

    public List<String> getAllUnitIds() throws Exception {
        this.loadMetadata();
        ArrayList<String> result = new ArrayList<String>();
        NodeList idAttributes = this.getChildrenOf(this.contentXml, "/repository/units/unit/@id");
        for (int ix = 0; ix < idAttributes.getLength(); ++ix) {
            Attr attribute = (Attr)idAttributes.item(ix);
            result.add(attribute.getValue());
        }
        return result;
    }

    public IU getUniqueIU(String unitId) throws Exception {
        this.loadMetadata();
        NodeList nodes = this.getChildrenOf(this.contentXml, "/repository/units/unit[@id='" + unitId + "']");
        if (nodes.getLength() == 0) {
            Assert.fail((String)("Could not find IU with id '" + unitId + "'"));
        } else {
            if (nodes.getLength() == 1) {
                return new IU(nodes.item(0));
            }
            Assert.fail((String)("Found more than one IU with id '" + unitId + "'"));
        }
        throw new RuntimeException();
    }

    private void loadMetadata() throws Exception {
        if (this.contentXml != null) {
            return;
        }
        if (this.metadataFile.getName().endsWith("jar")) {
            throw new UnsupportedOperationException("Can't read compressed p2 repositories yet");
        }
        this.contentXml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.metadataFile);
    }

    private XPath getXPathTool() {
        if (this.xPathTool == null) {
            this.xPathTool = XPathFactory.newInstance().newXPath();
        }
        return this.xPathTool;
    }

    NodeList getChildrenOf(Object startingPoint, String expression) throws XPathExpressionException {
        return (NodeList)this.getXPathTool().evaluate(expression, startingPoint, XPathConstants.NODESET);
    }

    Attr getAttribute(Node node, String expression) throws XPathExpressionException {
        return (Attr)this.getXPathTool().evaluate(expression, node, XPathConstants.NODE);
    }

    boolean isStrictRange(String range) {
        if (this.strictVersionRangePattern == null) {
            this.strictVersionRangePattern = Pattern.compile("\\[([^,]*),\\1\\]");
        }
        return this.strictVersionRangePattern.matcher(range).matches();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class IU {
        private final Node unitElement;

        IU(Node unitElement) {
            this.unitElement = unitElement;
        }

        public String getVersion() throws Exception {
            Attr version = P2RepositoryTool.this.getAttribute(this.unitElement, "@version");
            return version.getValue();
        }

        public List<String> getRequiredIds() throws Exception {
            ArrayList<String> result = new ArrayList<String>();
            NodeList requiredIds = P2RepositoryTool.this.getChildrenOf(this.unitElement, "requires/required/@name");
            for (int ix = 0; ix < requiredIds.getLength(); ++ix) {
                Attr attribute = (Attr)requiredIds.item(ix);
                result.add(attribute.getValue());
            }
            return result;
        }

        public List<String> getInclusionIds() throws Exception {
            ArrayList<String> result = new ArrayList<String>();
            NodeList requires = P2RepositoryTool.this.getChildrenOf(this.unitElement, "requires/required");
            for (int ix = 0; ix < requires.getLength(); ++ix) {
                Node require = requires.item(ix);
                Attr range = P2RepositoryTool.this.getAttribute(require, "@range");
                if (range == null || !P2RepositoryTool.this.isStrictRange(range.getValue())) continue;
                result.add(P2RepositoryTool.this.getAttribute(require, "@name").getValue());
            }
            return result;
        }
    }
}

