/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.test.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.codehaus.plexus.util.IOUtil;

public class ArchiveContentUtil {
    public static Set<String> getFilesInZip(File archive) throws Exception {
        final HashSet<String> result = new HashSet<String>();
        ArchiveContentUtil.visitEntries(archive, new ZipEntryVisitor(){

            @Override
            public boolean visitEntry(ZipEntry entry, ZipInputStream stream) {
                result.add(entry.getName());
                return true;
            }
        });
        return result;
    }

    public static String getFileContent(File archive, final String fileInArchive) throws Exception {
        final String[] result = new String[1];
        ArchiveContentUtil.visitEntries(archive, new ZipEntryVisitor(){

            @Override
            public boolean visitEntry(ZipEntry entry, ZipInputStream stream) throws Exception {
                if (fileInArchive.equals(entry.getName())) {
                    result[0] = IOUtil.toString((InputStream)stream);
                    return false;
                }
                return true;
            }
        });
        if (result[0] == null) {
            throw new IllegalArgumentException("File not found in archive: " + fileInArchive);
        }
        return result[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void visitEntries(File archive, ZipEntryVisitor visitor) throws Exception {
        try (FileInputStream fileStream = new FileInputStream(archive);
             ZipInputStream zipStream = new ZipInputStream(fileStream);){
            ArchiveContentUtil.visitEntries(zipStream, visitor);
        }
    }

    private static void visitEntries(ZipInputStream zipStream, ZipEntryVisitor visitor) throws Exception {
        ZipEntry entry = zipStream.getNextEntry();
        while (entry != null) {
            boolean continueVisiting = visitor.visitEntry(entry, zipStream);
            if (!continueVisiting) {
                return;
            }
            entry = zipStream.getNextEntry();
        }
    }

    private static interface ZipEntryVisitor {
        public boolean visitEntry(ZipEntry var1, ZipInputStream var2) throws Exception;
    }
}

