/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.testing;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.Maven;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugin.testing.AbstractMojoTestCase;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.MavenSettingsBuilder;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.component.configurator.ComponentConfigurator;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.tycho.testing.CompoundRuntimeException;
import org.eclipse.tycho.testing.TestUtil;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.util.DefaultRepositorySystemSession;

public class AbstractTychoMojoTestCase
extends AbstractMojoTestCase {
    protected Maven maven;
    private MavenSettingsBuilder settingsBuilder;
    private MavenExecutionRequestPopulator requestPopulator;

    protected void setUp() throws Exception {
        super.setUp();
        this.maven = (Maven)this.lookup(Maven.class);
        this.settingsBuilder = (MavenSettingsBuilder)this.lookup(MavenSettingsBuilder.class);
        this.requestPopulator = (MavenExecutionRequestPopulator)this.lookup(MavenExecutionRequestPopulator.class);
    }

    protected void tearDown() throws Exception {
        this.maven = null;
        super.tearDown();
    }

    protected String getCustomConfigurationName() {
        String name = AbstractTychoMojoTestCase.class.getName().replace('.', '/') + ".xml";
        return name;
    }

    protected ArtifactRepository getLocalRepository() throws Exception {
        RepositorySystem repoSystem = (RepositorySystem)this.lookup(RepositorySystem.class);
        File path = new File("target/local-repo").getAbsoluteFile();
        ArtifactRepository r = repoSystem.createLocalRepository(path);
        return r;
    }

    protected MavenExecutionRequest newMavenExecutionRequest(File pom) throws Exception {
        Properties systemProps = new Properties();
        systemProps.putAll((Map<?, ?>)System.getProperties());
        Properties userProps = new Properties();
        userProps.put("tycho-version", "0.0.0");
        DefaultMavenExecutionRequest request = new DefaultMavenExecutionRequest();
        request.setBaseDirectory(pom.getParentFile());
        request.setPom(pom);
        request.setSystemProperties(systemProps);
        request.setUserProperties(userProps);
        request.setLocalRepository(this.getLocalRepository());
        File settingsFile = this.getUserSettingsFile();
        if (settingsFile.isFile()) {
            request.setUserSettingsFile(settingsFile);
        }
        Settings settings = this.settingsBuilder.buildSettings((MavenExecutionRequest)request);
        this.requestPopulator.populateFromSettings((MavenExecutionRequest)request, settings);
        request.setGoals(Arrays.asList("validate"));
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getUserSettingsFile() throws IOException {
        String systemValue = System.getProperty("tycho.testSettings");
        if (systemValue != null) {
            return new File(systemValue);
        }
        Properties props = new Properties();
        try (InputStream stream = AbstractTychoMojoTestCase.class.getResourceAsStream("settings.properties");){
            props.load(stream);
        }
        String settingsFilePath = props.getProperty("settings.file");
        return new File(settingsFilePath);
    }

    protected List<MavenProject> getSortedProjects(File basedir) throws Exception {
        return this.getSortedProjects(basedir, null);
    }

    protected List<MavenProject> getSortedProjects(File basedir, File platform) throws Exception {
        return this.getSortedProjects(basedir, null, platform);
    }

    protected List<MavenProject> getSortedProjects(File basedir, Properties userProperties, File platform) throws Exception {
        MavenExecutionResult result;
        File pom = new File(basedir, "pom.xml");
        MavenExecutionRequest request = this.newMavenExecutionRequest(pom);
        request.getProjectBuildingRequest().setProcessPlugins(false);
        request.setLocalRepository(this.getLocalRepository());
        if (platform != null) {
            request.getUserProperties().put("tycho.targetPlatform", platform.getAbsolutePath());
        }
        if (userProperties != null) {
            request.getUserProperties().putAll((Map<?, ?>)userProperties);
        }
        if ((result = this.maven.execute(request)).hasExceptions()) {
            throw new CompoundRuntimeException(result.getExceptions());
        }
        return result.getTopologicallySortedProjects();
    }

    protected MavenSession newMavenSession(MavenProject project, List<MavenProject> projects) throws Exception {
        MavenExecutionRequest request = this.newMavenExecutionRequest(new File(project.getBasedir(), "pom.xml"));
        DefaultMavenExecutionResult result = new DefaultMavenExecutionResult();
        DefaultRepositorySystemSession repositorySession = new DefaultRepositorySystemSession();
        MavenSession session = new MavenSession(this.getContainer(), (RepositorySystemSession)repositorySession, request, (MavenExecutionResult)result);
        session.setProjects(projects);
        session.setCurrentProject(project);
        return session;
    }

    protected MavenProject getProject(List<MavenProject> projects, String artifactId) {
        for (MavenProject project : projects) {
            if (!artifactId.equals(project.getArtifactId())) continue;
            return project;
        }
        throw new IllegalArgumentException("No project with artifactId " + artifactId);
    }

    protected Mojo lookupMojoWithDefaultConfiguration(MavenProject project, MavenSession session, String goal) throws Exception {
        MojoExecution mojoExecution = this.newMojoExecution(goal);
        Xpp3Dom defaultConfiguration = mojoExecution.getConfiguration();
        PluginParameterExpressionEvaluator expressionEvaluator = new PluginParameterExpressionEvaluator(session, mojoExecution);
        ComponentConfigurator configurator = (ComponentConfigurator)this.getContainer().lookup(ComponentConfigurator.class, "basic");
        Mojo mojo = this.lookupEmptyMojo(goal, project.getFile());
        configurator.configureComponent((Object)mojo, (PlexusConfiguration)new XmlPlexusConfiguration(defaultConfiguration), (ExpressionEvaluator)expressionEvaluator, this.getContainer().getContainerRealm(), null);
        return mojo;
    }

    protected static File getBasedir(String name) throws IOException {
        return TestUtil.getBasedir(name);
    }
}

