/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions.engine;

import java.io.File;
import org.osgi.framework.Version;

public class Versions {
    public static String toCanonicalVersion(String version) {
        if (version == null) {
            return null;
        }
        if (version.endsWith("-SNAPSHOT")) {
            return version.substring(0, version.length() - "-SNAPSHOT".length()) + ".qualifier";
        }
        return version;
    }

    public static String incrementVersion(String version, int increment) {
        boolean isSnapshot = version.endsWith("-SNAPSHOT");
        if (isSnapshot) {
            version = version.substring(0, version.length() - "-SNAPSHOT".length());
        }
        Version osgi = new Version(version);
        String incremented = osgi.getMajor() + "." + osgi.getMinor() + "." + (osgi.getMicro() + increment);
        if (isSnapshot) {
            incremented = incremented + "-SNAPSHOT";
        }
        return incremented;
    }

    public static String toBaseVersion(String version) {
        if (version == null) {
            return null;
        }
        if (version.endsWith("-SNAPSHOT")) {
            return version.substring(0, version.length() - "-SNAPSHOT".length());
        }
        if (version.endsWith(".qualifier")) {
            return version.substring(0, version.length() - ".qualifier".length());
        }
        return version;
    }

    public static void assertIsOsgiVersion(String version) throws NumberFormatException, IllegalArgumentException, NullPointerException {
        new Version(version);
    }

    public static String toMavenVersion(String version) {
        if (version == null) {
            return null;
        }
        if (version.endsWith(".qualifier")) {
            return version.substring(0, version.length() - ".qualifier".length()) + "-SNAPSHOT";
        }
        return version;
    }

    public static boolean isVersionEquals(String a, String b) {
        return Versions.eq(Versions.toCanonicalVersion(a), Versions.toCanonicalVersion(b));
    }

    public static String validateOsgiVersion(String version, File location) {
        try {
            Versions.assertIsOsgiVersion(Versions.toCanonicalVersion(version));
        }
        catch (RuntimeException e) {
            return String.format("Version %s is not valid for %s", version, location);
        }
        return null;
    }

    public static <T> boolean eq(T a, T b) {
        return a != null ? a.equals(b) : b == null;
    }
}

