/*
 * Decompiled with CFR 0.152.
 */
package de.itemis.xtext.antlr.toolrunner;

import de.itemis.xtext.antlr.toolrunner.TailWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import org.antlr.Tool;
import org.antlr.tool.CompositeGrammar;
import org.antlr.tool.Grammar;

public class AntlrToolRunner {
    public static void runWithEncodingAndParams(String grammarFullPath, String explicitEncoding, String ... furtherArgs) {
        final String encoding = explicitEncoding != null ? explicitEncoding : Charset.defaultCharset().name();
        String[] args = new String[furtherArgs.length + 1];
        System.arraycopy(furtherArgs, 0, args, 0, furtherArgs.length);
        args[furtherArgs.length] = grammarFullPath;
        Tool antlr = new Tool(args){

            public Writer getOutputFile(Grammar g, String fileName) throws IOException {
                Writer result = this.superGetOutputFile(g, fileName);
                if (fileName.endsWith(".java")) {
                    result = new TailWriter(result, 2);
                }
                return result;
            }

            public Grammar getRootGrammar(String grammarFileName) throws IOException {
                CompositeGrammar composite = new CompositeGrammar();
                Grammar grammar = new Grammar((Tool)this, grammarFileName, composite);
                composite.setDelegationRoot(grammar);
                File f = null;
                f = this.isSet("haveInputDir") ? new File((String)this.get("inputDirectory"), grammarFileName) : new File(grammarFileName);
                this.set("parentGrammarDirectory", f.getParent());
                if (grammarFileName.lastIndexOf(File.separatorChar) == -1) {
                    this.set("parentGrammarDirectory", ".");
                } else {
                    this.set("parentGrammarDirectory", grammarFileName.substring(0, grammarFileName.lastIndexOf(File.separatorChar)));
                }
                FileInputStream inputStream = new FileInputStream(f);
                InputStreamReader reader = new InputStreamReader((InputStream)inputStream, encoding);
                BufferedReader br = new BufferedReader(reader);
                grammar.parseAndBuildAST((Reader)br);
                composite.watchNFAConversion = internalOption_watchNFAConversion;
                br.close();
                reader.close();
                inputStream.close();
                return grammar;
            }

            public void sortGrammarFiles() throws IOException {
            }

            protected Writer superGetOutputFile(Grammar g, String fileName) throws IOException {
                if (this.getOutputDirectory() == null) {
                    return new StringWriter();
                }
                File outputDir = fileName.endsWith(".tokens") ? (this.isSet("haveOutputDir") ? new File(this.getOutputDirectory()) : new File(".")) : this.getOutputDirectory(g.getFileName());
                File outputFile = new File(outputDir, fileName);
                if (!outputDir.exists()) {
                    outputDir.mkdirs();
                }
                FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, encoding);
                return new BufferedWriter(writer);
            }

            private boolean isSet(String fieldName) {
                try {
                    Field field = Tool.class.getDeclaredField(fieldName);
                    field.setAccessible(true);
                    boolean result = field.getBoolean((Object)this);
                    return result;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            private <T> T get(String fieldName) {
                try {
                    Field field = Tool.class.getDeclaredField(fieldName);
                    field.setAccessible(true);
                    Object result = field.get((Object)this);
                    return (T)result;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            private void set(String fieldName, Object value) {
                try {
                    Field field = Tool.class.getDeclaredField(fieldName);
                    field.setAccessible(true);
                    field.set((Object)this, value);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        antlr.process();
    }

    public static void runWithParams(String grammarFullPath, String ... furtherArgs) {
        AntlrToolRunner.runWithEncodingAndParams(grammarFullPath, Charset.defaultCharset().name(), furtherArgs);
    }

    public static void run(String grammarFullPath) {
        AntlrToolRunner.runWithParams(grammarFullPath, new String[0]);
    }
}

