/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty3;

import java.net.SocketAddress;
import java.util.Map;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.transport.netty3.Netty3Utils;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;

public class Netty3HttpRequest
extends RestRequest {
    private final HttpRequest request;
    private final Channel channel;
    private final BytesReference content;

    public Netty3HttpRequest(NamedXContentRegistry xContentRegistry, HttpRequest request, Channel channel) {
        super(xContentRegistry, request.getUri());
        this.request = request;
        this.channel = channel;
        this.content = request.getContent().readable() ? Netty3Utils.toBytesReference(request.getContent()) : BytesArray.EMPTY;
    }

    public HttpRequest request() {
        return this.request;
    }

    public RestRequest.Method method() {
        HttpMethod httpMethod = this.request.getMethod();
        if (httpMethod == HttpMethod.GET) {
            return RestRequest.Method.GET;
        }
        if (httpMethod == HttpMethod.POST) {
            return RestRequest.Method.POST;
        }
        if (httpMethod == HttpMethod.PUT) {
            return RestRequest.Method.PUT;
        }
        if (httpMethod == HttpMethod.DELETE) {
            return RestRequest.Method.DELETE;
        }
        if (httpMethod == HttpMethod.HEAD) {
            return RestRequest.Method.HEAD;
        }
        if (httpMethod == HttpMethod.OPTIONS) {
            return RestRequest.Method.OPTIONS;
        }
        return RestRequest.Method.GET;
    }

    public String uri() {
        return this.request.getUri();
    }

    public boolean hasContent() {
        return this.content.length() > 0;
    }

    public BytesReference content() {
        return this.content;
    }

    public SocketAddress getRemoteAddress() {
        return this.channel.getRemoteAddress();
    }

    public SocketAddress getLocalAddress() {
        return this.channel.getLocalAddress();
    }

    public Channel getChannel() {
        return this.channel;
    }

    public String header(String name) {
        return this.request.headers().get(name);
    }

    public Iterable<Map.Entry<String, String>> headers() {
        return this.request.headers().entries();
    }
}

