/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty3;

import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.cursors.IntCursor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.NetworkExceptionHelper;
import org.elasticsearch.common.transport.PortsRange;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.http.BindHttpException;
import org.elasticsearch.http.HttpInfo;
import org.elasticsearch.http.HttpServerAdapter;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.HttpStats;
import org.elasticsearch.http.HttpTransportSettings;
import org.elasticsearch.http.netty3.ESNetty3HttpResponseEncoder;
import org.elasticsearch.http.netty3.Netty3HttpRequestHandler;
import org.elasticsearch.http.netty3.cors.Netty3CorsConfig;
import org.elasticsearch.http.netty3.cors.Netty3CorsConfigBuilder;
import org.elasticsearch.http.netty3.cors.Netty3CorsHandler;
import org.elasticsearch.http.netty3.pipelining.HttpPipeliningHandler;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BindTransportException;
import org.elasticsearch.transport.netty3.Netty3OpenChannelsHandler;
import org.elasticsearch.transport.netty3.Netty3Utils;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.AdaptiveReceiveBufferSizePredictorFactory;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.FixedReceiveBufferSizePredictorFactory;
import org.jboss.netty.channel.ReceiveBufferSizePredictorFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.oio.OioServerSocketChannelFactory;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpContentCompressor;
import org.jboss.netty.handler.codec.http.HttpContentDecompressor;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.timeout.ReadTimeoutException;

public class Netty3HttpServerTransport
extends AbstractLifecycleComponent
implements HttpServerTransport {
    public static Setting<ByteSizeValue> SETTING_HTTP_NETTY_MAX_CUMULATION_BUFFER_CAPACITY;
    public static Setting<Integer> SETTING_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS;
    public static final Setting<Integer> SETTING_HTTP_WORKER_COUNT;
    public static final Setting<Boolean> SETTING_HTTP_TCP_NO_DELAY;
    public static final Setting<Boolean> SETTING_HTTP_TCP_KEEP_ALIVE;
    public static final Setting<Boolean> SETTING_HTTP_TCP_BLOCKING_SERVER;
    public static final Setting<Boolean> SETTING_HTTP_TCP_REUSE_ADDRESS;
    public static final Setting<ByteSizeValue> SETTING_HTTP_TCP_SEND_BUFFER_SIZE;
    public static final Setting<ByteSizeValue> SETTING_HTTP_TCP_RECEIVE_BUFFER_SIZE;
    public static final Setting<ByteSizeValue> SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_SIZE;
    public static final Setting<ByteSizeValue> SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_MIN;
    public static final Setting<ByteSizeValue> SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_MAX;
    protected final NetworkService networkService;
    protected final BigArrays bigArrays;
    protected final ByteSizeValue maxContentLength;
    protected final ByteSizeValue maxInitialLineLength;
    protected final ByteSizeValue maxHeaderSize;
    protected final ByteSizeValue maxChunkSize;
    protected final int workerCount;
    protected final boolean blockingServer;
    protected final boolean pipelining;
    protected final int pipeliningMaxEvents;
    protected final boolean compression;
    protected final int compressionLevel;
    protected final boolean resetCookies;
    protected final PortsRange port;
    protected final String[] bindHosts;
    protected final String[] publishHosts;
    protected final boolean detailedErrorsEnabled;
    protected final ThreadPool threadPool;
    protected final NamedXContentRegistry xContentRegistry;
    protected final boolean tcpNoDelay;
    protected final boolean tcpKeepAlive;
    protected final boolean reuseAddress;
    protected final ByteSizeValue tcpSendBufferSize;
    protected final ByteSizeValue tcpReceiveBufferSize;
    protected final ReceiveBufferSizePredictorFactory receiveBufferSizePredictorFactory;
    protected final ByteSizeValue maxCumulationBufferCapacity;
    protected final int maxCompositeBufferComponents;
    protected volatile ServerBootstrap serverBootstrap;
    protected volatile BoundTransportAddress boundAddress;
    protected volatile List<Channel> serverChannels = new ArrayList<Channel>();
    Netty3OpenChannelsHandler serverOpenChannels;
    protected volatile HttpServerAdapter httpServerAdapter;
    private final Netty3CorsConfig corsConfig;

    public Netty3HttpServerTransport(Settings settings, NetworkService networkService, BigArrays bigArrays, ThreadPool threadPool, NamedXContentRegistry xContentRegistry) {
        super(settings);
        this.networkService = networkService;
        this.bigArrays = bigArrays;
        this.threadPool = threadPool;
        this.xContentRegistry = xContentRegistry;
        ByteSizeValue maxContentLength = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_MAX_CONTENT_LENGTH.get(settings);
        this.maxChunkSize = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_MAX_CHUNK_SIZE.get(settings);
        this.maxHeaderSize = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_MAX_HEADER_SIZE.get(settings);
        this.maxInitialLineLength = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_MAX_INITIAL_LINE_LENGTH.get(settings);
        this.resetCookies = (Boolean)HttpTransportSettings.SETTING_HTTP_RESET_COOKIES.get(settings);
        this.maxCumulationBufferCapacity = (ByteSizeValue)SETTING_HTTP_NETTY_MAX_CUMULATION_BUFFER_CAPACITY.get(settings);
        this.maxCompositeBufferComponents = (Integer)SETTING_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS.get(settings);
        this.workerCount = (Integer)SETTING_HTTP_WORKER_COUNT.get(settings);
        this.blockingServer = (Boolean)SETTING_HTTP_TCP_BLOCKING_SERVER.get(settings);
        this.port = (PortsRange)HttpTransportSettings.SETTING_HTTP_PORT.get(settings);
        this.bindHosts = ((List)HttpTransportSettings.SETTING_HTTP_BIND_HOST.get(settings)).toArray(Strings.EMPTY_ARRAY);
        this.publishHosts = ((List)HttpTransportSettings.SETTING_HTTP_PUBLISH_HOST.get(settings)).toArray(Strings.EMPTY_ARRAY);
        this.tcpNoDelay = (Boolean)SETTING_HTTP_TCP_NO_DELAY.get(settings);
        this.tcpKeepAlive = (Boolean)SETTING_HTTP_TCP_KEEP_ALIVE.get(settings);
        this.reuseAddress = (Boolean)SETTING_HTTP_TCP_REUSE_ADDRESS.get(settings);
        this.tcpSendBufferSize = (ByteSizeValue)SETTING_HTTP_TCP_SEND_BUFFER_SIZE.get(settings);
        this.tcpReceiveBufferSize = (ByteSizeValue)SETTING_HTTP_TCP_RECEIVE_BUFFER_SIZE.get(settings);
        this.detailedErrorsEnabled = (Boolean)HttpTransportSettings.SETTING_HTTP_DETAILED_ERRORS_ENABLED.get(settings);
        ByteSizeValue receivePredictorMin = (ByteSizeValue)SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_MIN.get(settings);
        ByteSizeValue receivePredictorMax = (ByteSizeValue)SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_MAX.get(settings);
        this.receiveBufferSizePredictorFactory = receivePredictorMax.getBytes() == receivePredictorMin.getBytes() ? new FixedReceiveBufferSizePredictorFactory((int)receivePredictorMax.getBytes()) : new AdaptiveReceiveBufferSizePredictorFactory((int)receivePredictorMin.getBytes(), (int)receivePredictorMin.getBytes(), (int)receivePredictorMax.getBytes());
        this.compression = (Boolean)HttpTransportSettings.SETTING_HTTP_COMPRESSION.get(settings);
        this.compressionLevel = (Integer)HttpTransportSettings.SETTING_HTTP_COMPRESSION_LEVEL.get(settings);
        this.pipelining = (Boolean)HttpTransportSettings.SETTING_PIPELINING.get(settings);
        this.pipeliningMaxEvents = (Integer)HttpTransportSettings.SETTING_PIPELINING_MAX_EVENTS.get(settings);
        this.corsConfig = this.buildCorsConfig(settings);
        if (maxContentLength.getBytes() > Integer.MAX_VALUE) {
            this.logger.warn("maxContentLength[{}] set to high value, resetting it to [100mb]", (Object)maxContentLength);
            maxContentLength = new ByteSizeValue(100L, ByteSizeUnit.MB);
        }
        this.maxContentLength = maxContentLength;
        this.logger.debug("using max_chunk_size[{}], max_header_size[{}], max_initial_line_length[{}], max_content_length[{}], receive_predictor[{}->{}], pipelining[{}], pipelining_max_events[{}]", (Object)this.maxChunkSize, (Object)this.maxHeaderSize, (Object)this.maxInitialLineLength, (Object)this.maxContentLength, (Object)receivePredictorMin, (Object)receivePredictorMax, (Object)this.pipelining, (Object)this.pipeliningMaxEvents);
    }

    public Settings settings() {
        return this.settings;
    }

    public void httpServerAdapter(HttpServerAdapter httpServerAdapter) {
        this.httpServerAdapter = httpServerAdapter;
    }

    protected void doStart() {
        boolean success = false;
        try {
            this.serverOpenChannels = new Netty3OpenChannelsHandler(this.logger);
            this.serverBootstrap = this.blockingServer ? new ServerBootstrap((ChannelFactory)new OioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory((Settings)this.settings, (String)"http_server_boss")), (Executor)Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory((Settings)this.settings, (String)"http_server_worker")))) : new ServerBootstrap((ChannelFactory)new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory((Settings)this.settings, (String)"http_server_boss")), (Executor)Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory((Settings)this.settings, (String)"http_server_worker")), this.workerCount));
            this.serverBootstrap.setPipelineFactory(this.configureServerChannelPipelineFactory());
            this.serverBootstrap.setOption("child.tcpNoDelay", (Object)this.tcpNoDelay);
            this.serverBootstrap.setOption("child.keepAlive", (Object)this.tcpKeepAlive);
            if (this.tcpSendBufferSize.getBytes() > 0L) {
                this.serverBootstrap.setOption("child.sendBufferSize", (Object)this.tcpSendBufferSize.getBytes());
            }
            if (this.tcpReceiveBufferSize.getBytes() > 0L) {
                this.serverBootstrap.setOption("child.receiveBufferSize", (Object)this.tcpReceiveBufferSize.getBytes());
            }
            this.serverBootstrap.setOption("receiveBufferSizePredictorFactory", (Object)this.receiveBufferSizePredictorFactory);
            this.serverBootstrap.setOption("child.receiveBufferSizePredictorFactory", (Object)this.receiveBufferSizePredictorFactory);
            this.serverBootstrap.setOption("reuseAddress", (Object)this.reuseAddress);
            this.serverBootstrap.setOption("child.reuseAddress", (Object)this.reuseAddress);
            this.boundAddress = this.createBoundHttpAddress();
            success = true;
        }
        finally {
            if (!success) {
                this.doStop();
            }
        }
    }

    private BoundTransportAddress createBoundHttpAddress() {
        InetAddress publishInetAddress;
        InetAddress[] hostAddresses;
        try {
            hostAddresses = this.networkService.resolveBindHostAddresses(this.bindHosts);
        }
        catch (IOException e) {
            throw new BindHttpException("Failed to resolve host [" + Arrays.toString(this.bindHosts) + "]", (Throwable)e);
        }
        ArrayList<InetSocketTransportAddress> boundAddresses = new ArrayList<InetSocketTransportAddress>(hostAddresses.length);
        for (InetAddress address : hostAddresses) {
            boundAddresses.add(this.bindAddress(address));
        }
        try {
            publishInetAddress = this.networkService.resolvePublishHostAddresses(this.publishHosts);
        }
        catch (Exception e) {
            throw new BindTransportException("Failed to resolve publish address", (Throwable)e);
        }
        int publishPort = Netty3HttpServerTransport.resolvePublishPort(this.settings, boundAddresses, publishInetAddress);
        InetSocketAddress publishAddress = new InetSocketAddress(publishInetAddress, publishPort);
        return new BoundTransportAddress(boundAddresses.toArray(new TransportAddress[0]), (TransportAddress)new InetSocketTransportAddress(publishAddress));
    }

    static int resolvePublishPort(Settings settings, List<InetSocketTransportAddress> boundAddresses, InetAddress publishInetAddress) {
        int publishPort = (Integer)HttpTransportSettings.SETTING_HTTP_PUBLISH_PORT.get(settings);
        if (publishPort < 0) {
            for (InetSocketTransportAddress boundAddress : boundAddresses) {
                InetAddress boundInetAddress = boundAddress.address().getAddress();
                if (!boundInetAddress.isAnyLocalAddress() && !boundInetAddress.equals(publishInetAddress)) continue;
                publishPort = boundAddress.getPort();
                break;
            }
        }
        if (publishPort < 0) {
            IntHashSet ports = new IntHashSet();
            for (InetSocketTransportAddress boundAddress : boundAddresses) {
                ports.add(boundAddress.getPort());
            }
            if (ports.size() == 1) {
                publishPort = ((IntCursor)ports.iterator().next()).value;
            }
        }
        if (publishPort < 0) {
            throw new BindHttpException("Failed to auto-resolve http publish port, multiple bound addresses " + boundAddresses + " with distinct ports and none of them matched the publish address (" + publishInetAddress + "). Please specify a unique port by setting " + HttpTransportSettings.SETTING_HTTP_PORT.getKey() + " or " + HttpTransportSettings.SETTING_HTTP_PUBLISH_PORT.getKey());
        }
        return publishPort;
    }

    private Netty3CorsConfig buildCorsConfig(Settings settings) {
        Pattern p;
        if (!((Boolean)HttpTransportSettings.SETTING_CORS_ENABLED.get(settings)).booleanValue()) {
            return Netty3CorsConfigBuilder.forOrigins(new String[0]).disable().build();
        }
        String origin = (String)HttpTransportSettings.SETTING_CORS_ALLOW_ORIGIN.get(settings);
        Netty3CorsConfigBuilder builder = Strings.isNullOrEmpty((String)origin) ? Netty3CorsConfigBuilder.forOrigins(new String[0]) : (origin.equals("*") ? Netty3CorsConfigBuilder.forAnyOrigin() : ((p = RestUtils.checkCorsSettingForRegex((String)origin)) == null ? Netty3CorsConfigBuilder.forOrigins(RestUtils.corsSettingAsArray((String)origin)) : Netty3CorsConfigBuilder.forPattern(p)));
        if (((Boolean)HttpTransportSettings.SETTING_CORS_ALLOW_CREDENTIALS.get(settings)).booleanValue()) {
            builder.allowCredentials();
        }
        Set strMethods = Strings.splitStringByCommaToSet((String)((String)HttpTransportSettings.SETTING_CORS_ALLOW_METHODS.get(settings)));
        return builder.allowedRequestMethods(strMethods.stream().map(HttpMethod::valueOf).collect(Collectors.toSet())).maxAge(((Integer)HttpTransportSettings.SETTING_CORS_MAX_AGE.get(settings)).intValue()).allowedRequestHeaders(Strings.splitStringByCommaToSet((String)((String)HttpTransportSettings.SETTING_CORS_ALLOW_HEADERS.get(settings)))).shortCircuit().build();
    }

    private InetSocketTransportAddress bindAddress(InetAddress hostAddress) {
        AtomicReference boundSocket = new AtomicReference();
        AtomicReference lastException = new AtomicReference();
        boolean success = this.port.iterate(portNumber -> {
            try {
                List<Channel> list = this.serverChannels;
                synchronized (list) {
                    Channel channel = this.serverBootstrap.bind((SocketAddress)new InetSocketAddress(hostAddress, portNumber));
                    this.serverChannels.add(channel);
                    boundSocket.set((InetSocketAddress)channel.getLocalAddress());
                }
            }
            catch (Exception e) {
                lastException.set(e);
                return false;
            }
            return true;
        });
        if (!success) {
            throw new BindHttpException("Failed to bind to [" + this.port.getPortRangeString() + "]", (Throwable)lastException.get());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Bound http to address {{}}", (Object)NetworkAddress.format((InetSocketAddress)((InetSocketAddress)boundSocket.get())));
        }
        return new InetSocketTransportAddress((InetSocketAddress)boundSocket.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() {
        List<Channel> list = this.serverChannels;
        synchronized (list) {
            if (this.serverChannels != null) {
                for (Channel channel : this.serverChannels) {
                    channel.close().awaitUninterruptibly();
                }
                this.serverChannels = null;
            }
        }
        if (this.serverOpenChannels != null) {
            this.serverOpenChannels.close();
            this.serverOpenChannels = null;
        }
        if (this.serverBootstrap != null) {
            this.serverBootstrap.releaseExternalResources();
            this.serverBootstrap = null;
        }
    }

    protected void doClose() {
    }

    public BoundTransportAddress boundAddress() {
        return this.boundAddress;
    }

    public HttpInfo info() {
        BoundTransportAddress boundTransportAddress = this.boundAddress();
        if (boundTransportAddress == null) {
            return null;
        }
        return new HttpInfo(boundTransportAddress, this.maxContentLength.getBytes());
    }

    public HttpStats stats() {
        Netty3OpenChannelsHandler channels = this.serverOpenChannels;
        return new HttpStats(channels == null ? 0L : channels.numberOfOpenChannels(), channels == null ? 0L : channels.totalChannels());
    }

    public Netty3CorsConfig getCorsConfig() {
        return this.corsConfig;
    }

    protected void dispatchRequest(RestRequest request, RestChannel channel) {
        this.httpServerAdapter.dispatchRequest(request, channel, this.threadPool.getThreadContext());
    }

    protected void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Netty3Utils.maybeDie(e.getCause());
        if (e.getCause() instanceof ReadTimeoutException) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Connection timeout [{}]", (Object)ctx.getChannel().getRemoteAddress());
            }
            ctx.getChannel().close();
        } else {
            if (!this.lifecycle.started()) {
                return;
            }
            if (!NetworkExceptionHelper.isCloseConnectionException((Throwable)e.getCause())) {
                this.logger.warn(() -> new ParameterizedMessage("Caught exception while handling client http traffic, closing connection {}", (Object)ctx.getChannel()), e.getCause());
                ctx.getChannel().close();
            } else {
                this.logger.debug(() -> new ParameterizedMessage("Caught exception while handling client http traffic, closing connection {}", (Object)ctx.getChannel()), e.getCause());
                ctx.getChannel().close();
            }
        }
    }

    public ChannelPipelineFactory configureServerChannelPipelineFactory() {
        return new HttpChannelPipelineFactory(this, this.detailedErrorsEnabled, this.threadPool.getThreadContext());
    }

    static {
        Netty3Utils.setup();
        SETTING_HTTP_NETTY_MAX_CUMULATION_BUFFER_CAPACITY = Setting.byteSizeSetting((String)"http.netty.max_cumulation_buffer_capacity", (ByteSizeValue)new ByteSizeValue(-1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
        SETTING_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS = Setting.intSetting((String)"http.netty.max_composite_buffer_components", (int)-1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
        SETTING_HTTP_WORKER_COUNT = new Setting("http.netty.worker_count", s -> Integer.toString(EsExecutors.boundedNumberOfProcessors((Settings)s) * 2), s -> Setting.parseInt((String)s, (int)1, (String)"http.netty.worker_count"), new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
        SETTING_HTTP_TCP_NO_DELAY = Setting.boolSetting((String)"http.tcp_no_delay", (Setting)NetworkService.TcpSettings.TCP_NO_DELAY, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
        SETTING_HTTP_TCP_KEEP_ALIVE = Setting.boolSetting((String)"http.tcp.keep_alive", (Setting)NetworkService.TcpSettings.TCP_KEEP_ALIVE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
        SETTING_HTTP_TCP_BLOCKING_SERVER = Setting.boolSetting((String)"http.tcp.blocking_server", (Setting)NetworkService.TcpSettings.TCP_BLOCKING_SERVER, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
        SETTING_HTTP_TCP_REUSE_ADDRESS = Setting.boolSetting((String)"http.tcp.reuse_address", (Setting)NetworkService.TcpSettings.TCP_REUSE_ADDRESS, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
        SETTING_HTTP_TCP_SEND_BUFFER_SIZE = Setting.byteSizeSetting((String)"http.tcp.send_buffer_size", (Setting)NetworkService.TcpSettings.TCP_SEND_BUFFER_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
        SETTING_HTTP_TCP_RECEIVE_BUFFER_SIZE = Setting.byteSizeSetting((String)"http.tcp.receive_buffer_size", (Setting)NetworkService.TcpSettings.TCP_RECEIVE_BUFFER_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
        SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_SIZE = Setting.byteSizeSetting((String)"transport.netty.receive_predictor_size", settings -> {
            long defaultReceiverPredictor = 524288L;
            if (JvmInfo.jvmInfo().getMem().getDirectMemoryMax().getBytes() > 0L) {
                long l = (long)(0.3 * (double)JvmInfo.jvmInfo().getMem().getDirectMemoryMax().getBytes() / (double)((Integer)SETTING_HTTP_WORKER_COUNT.get(settings)).intValue());
                defaultReceiverPredictor = Math.min(defaultReceiverPredictor, Math.max(l, 65536L));
            }
            return new ByteSizeValue(defaultReceiverPredictor).toString();
        }, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_MIN = Setting.byteSizeSetting((String)"http.netty.receive_predictor_min", SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_MAX = Setting.byteSizeSetting((String)"http.netty.receive_predictor_max", SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    }

    protected static class HttpChannelPipelineFactory
    implements ChannelPipelineFactory {
        protected final Netty3HttpServerTransport transport;
        protected final Netty3HttpRequestHandler requestHandler;

        public HttpChannelPipelineFactory(Netty3HttpServerTransport transport, boolean detailedErrorsEnabled, ThreadContext threadContext) {
            this.transport = transport;
            this.requestHandler = new Netty3HttpRequestHandler(transport, detailedErrorsEnabled, threadContext);
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = Channels.pipeline();
            pipeline.addLast("openChannels", (ChannelHandler)this.transport.serverOpenChannels);
            HttpRequestDecoder requestDecoder = new HttpRequestDecoder((int)this.transport.maxInitialLineLength.getBytes(), (int)this.transport.maxHeaderSize.getBytes(), (int)this.transport.maxChunkSize.getBytes());
            if (this.transport.maxCumulationBufferCapacity.getBytes() >= 0L) {
                if (this.transport.maxCumulationBufferCapacity.getBytes() > Integer.MAX_VALUE) {
                    requestDecoder.setMaxCumulationBufferCapacity(Integer.MAX_VALUE);
                } else {
                    requestDecoder.setMaxCumulationBufferCapacity((int)this.transport.maxCumulationBufferCapacity.getBytes());
                }
            }
            if (this.transport.maxCompositeBufferComponents != -1) {
                requestDecoder.setMaxCumulationBufferComponents(this.transport.maxCompositeBufferComponents);
            }
            pipeline.addLast("decoder", (ChannelHandler)requestDecoder);
            pipeline.addLast("decoder_compress", (ChannelHandler)new HttpContentDecompressor());
            HttpChunkAggregator httpChunkAggregator = new HttpChunkAggregator((int)this.transport.maxContentLength.getBytes());
            if (this.transport.maxCompositeBufferComponents != -1) {
                httpChunkAggregator.setMaxCumulationBufferComponents(this.transport.maxCompositeBufferComponents);
            }
            pipeline.addLast("aggregator", (ChannelHandler)httpChunkAggregator);
            pipeline.addLast("encoder", (ChannelHandler)new ESNetty3HttpResponseEncoder());
            if (this.transport.compression) {
                pipeline.addLast("encoder_compress", (ChannelHandler)new HttpContentCompressor(this.transport.compressionLevel));
            }
            if (((Boolean)HttpTransportSettings.SETTING_CORS_ENABLED.get(this.transport.settings())).booleanValue()) {
                pipeline.addLast("cors", (ChannelHandler)new Netty3CorsHandler(this.transport.getCorsConfig()));
            }
            if (this.transport.pipelining) {
                pipeline.addLast("pipelining", (ChannelHandler)new HttpPipeliningHandler(this.transport.pipeliningMaxEvents));
            }
            pipeline.addLast("handler", (ChannelHandler)this.requestHandler);
            return pipeline;
        }
    }
}

