/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4.pipelining;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.LastHttpContent;
import java.util.Collections;
import java.util.PriorityQueue;
import org.elasticsearch.http.netty4.pipelining.HttpPipelinedRequest;
import org.elasticsearch.http.netty4.pipelining.HttpPipelinedResponse;
import org.elasticsearch.transport.netty4.Netty4Utils;

public class HttpPipeliningHandler
extends ChannelDuplexHandler {
    private static final int INITIAL_EVENTS_HELD = 8;
    private final int maxEventsHeld;
    private int readSequence;
    private int writeSequence;
    private final PriorityQueue<HttpPipelinedResponse> holdingQueue;

    public HttpPipeliningHandler(int maxEventsHeld) {
        this.maxEventsHeld = maxEventsHeld;
        this.holdingQueue = new PriorityQueue(8);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof LastHttpContent) {
            ctx.fireChannelRead((Object)new HttpPipelinedRequest(((LastHttpContent)msg).retain(), this.readSequence++));
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof HttpPipelinedResponse) {
            HttpPipelinedResponse current = (HttpPipelinedResponse)msg;
            assert (current.promise() == promise);
            boolean channelShouldClose = false;
            PriorityQueue<HttpPipelinedResponse> priorityQueue = this.holdingQueue;
            synchronized (priorityQueue) {
                if (this.holdingQueue.size() < this.maxEventsHeld) {
                    HttpPipelinedResponse top;
                    this.holdingQueue.add(current);
                    while (!this.holdingQueue.isEmpty() && (top = this.holdingQueue.peek()).sequence() == this.writeSequence) {
                        this.holdingQueue.remove();
                        ctx.write((Object)top.response(), top.promise());
                        ++this.writeSequence;
                    }
                } else {
                    channelShouldClose = true;
                }
            }
            if (channelShouldClose) {
                try {
                    Netty4Utils.closeChannels(Collections.singletonList(ctx.channel()));
                }
                finally {
                    current.release();
                    promise.setSuccess();
                }
            }
        } else {
            ctx.write(msg, promise);
        }
    }
}

