/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.concurrent.CompletableContext;
import org.elasticsearch.transport.TcpServerChannel;

public class Netty4TcpServerChannel
implements TcpServerChannel {
    private final Channel channel;
    private final String profile;
    private final CompletableContext<Void> closeContext = new CompletableContext();

    Netty4TcpServerChannel(Channel channel, String profile) {
        this.channel = channel;
        this.profile = profile;
        this.channel.closeFuture().addListener(f -> {
            if (f.isSuccess()) {
                this.closeContext.complete(null);
            } else {
                Throwable cause = f.cause();
                if (cause instanceof Error) {
                    ExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
                    this.closeContext.completeExceptionally(new Exception(cause));
                } else {
                    this.closeContext.completeExceptionally((Exception)cause);
                }
            }
        });
    }

    public String getProfile() {
        return this.profile;
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.channel.localAddress();
    }

    public void close() {
        this.channel.close();
    }

    public void addCloseListener(ActionListener<Void> listener) {
        this.closeContext.addListener(ActionListener.toBiConsumer(listener));
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public String toString() {
        return "Netty4TcpChannel{localAddress=" + this.getLocalAddress() + '}';
    }
}

