/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cli;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Deque;
import org.elasticsearch.cli.Terminal;

public class MockTerminal
extends Terminal {
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private final PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.buffer, StandardCharsets.UTF_8));
    private final Deque<String> textInput = new ArrayDeque<String>();
    private final Deque<String> secretInput = new ArrayDeque<String>();

    public MockTerminal() {
        super("\n");
    }

    public String readText(String prompt) {
        if (this.textInput.isEmpty()) {
            throw new IllegalStateException("No text input configured for prompt [" + prompt + "]");
        }
        return this.textInput.removeFirst();
    }

    public char[] readSecret(String prompt) {
        if (this.secretInput.isEmpty()) {
            throw new IllegalStateException("No secret input configured for prompt [" + prompt + "]");
        }
        return this.secretInput.removeFirst().toCharArray();
    }

    public PrintWriter getWriter() {
        return this.writer;
    }

    public void addTextInput(String input) {
        this.textInput.addLast(input);
    }

    public void addSecretInput(String input) {
        this.secretInput.addLast(input);
    }

    public String getOutput() throws UnsupportedEncodingException {
        return this.buffer.toString("UTF-8");
    }

    public void reset() {
        this.buffer.reset();
        this.textInput.clear();
        this.secretInput.clear();
    }
}

