/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.disruption;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.InternalTestCluster;
import org.elasticsearch.test.disruption.NetworkDisruption;
import org.elasticsearch.test.transport.MockTransportService;

public class NetworkDisruptionIT
extends ESIntegTestCase {
    @Override
    protected Collection<Class<? extends Plugin>> nodePlugins() {
        return Arrays.asList(MockTransportService.TestPlugin.class);
    }

    public void testNetworkPartitionWithNodeShutdown() throws IOException {
        NetworkDisruptionIT.internalCluster().ensureAtLeastNumDataNodes(2);
        String[] nodeNames = NetworkDisruptionIT.internalCluster().getNodeNames();
        NetworkDisruption networkDisruption = new NetworkDisruption(new NetworkDisruption.TwoPartitions(nodeNames[0], nodeNames[1]), new NetworkDisruption.NetworkUnresponsive());
        NetworkDisruptionIT.internalCluster().setDisruptionScheme(networkDisruption);
        networkDisruption.startDisrupting();
        NetworkDisruptionIT.internalCluster().stopRandomNode(InternalTestCluster.nameFilter(nodeNames[0]));
        NetworkDisruptionIT.internalCluster().clearDisruptionScheme();
    }
}

