/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.engine;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.IndexSearcher;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.ShardId;

class AssertingSearcher
extends Engine.Searcher {
    private final Engine.Searcher wrappedSearcher;
    private final ShardId shardId;
    private RuntimeException firstReleaseStack;
    private final Object lock = new Object();
    private final int initialRefCount;
    private final Logger logger;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    AssertingSearcher(IndexSearcher indexSearcher, Engine.Searcher wrappedSearcher, ShardId shardId, Logger logger) {
        super(wrappedSearcher.source(), indexSearcher);
        this.wrappedSearcher = wrappedSearcher;
        this.logger = logger;
        this.shardId = shardId;
        this.initialRefCount = wrappedSearcher.reader().getRefCount();
        assert (this.initialRefCount > 0) : "IndexReader#getRefCount() was [" + this.initialRefCount + "] expected a value > [0] - reader is already closed";
    }

    public String source() {
        return this.wrappedSearcher.source();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed.compareAndSet(false, true)) {
                this.firstReleaseStack = new RuntimeException();
                int refCount = this.wrappedSearcher.reader().getRefCount();
                assert (refCount > 0) : "IndexReader#getRefCount() was [" + refCount + "] expected a value > [0] - reader is already closed. Initial refCount was: [" + this.initialRefCount + "]";
                try {
                    this.wrappedSearcher.close();
                }
                catch (RuntimeException ex) {
                    this.logger.debug("Failed to release searcher", (Throwable)ex);
                    throw ex;
                }
            } else {
                AssertionError error = new AssertionError((Object)("Released Searcher more than once, source [" + this.wrappedSearcher.source() + "]"));
                ((Throwable)((Object)error)).initCause(this.firstReleaseStack);
                throw error;
            }
        }
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public boolean isOpen() {
        return !this.closed.get();
    }
}

