/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.test.rest.yaml.ClientYamlTestResponse;
import org.elasticsearch.test.rest.yaml.ClientYamlTestResponseException;
import org.elasticsearch.test.rest.yaml.restspec.ClientYamlSuiteRestApi;
import org.elasticsearch.test.rest.yaml.restspec.ClientYamlSuiteRestPath;
import org.elasticsearch.test.rest.yaml.restspec.ClientYamlSuiteRestSpec;

public class ClientYamlTestClient {
    private static final Logger logger = Loggers.getLogger(ClientYamlTestClient.class);
    private static final Set<String> ALWAYS_ACCEPTED_QUERY_STRING_PARAMS = Sets.newHashSet((Object[])new String[]{"error_trace", "filter_path", "pretty", "source"});
    private final ClientYamlSuiteRestSpec restSpec;
    private final RestClient restClient;
    private final Version esVersion;

    public ClientYamlTestClient(ClientYamlSuiteRestSpec restSpec, RestClient restClient, List<HttpHost> hosts, Version esVersion) throws IOException {
        assert (hosts.size() > 0);
        this.restSpec = restSpec;
        this.restClient = restClient;
        this.esVersion = esVersion;
    }

    public Version getEsVersion() {
        return this.esVersion;
    }

    public ClientYamlTestResponse callApi(String apiName, Map<String, String> params, String body, Map<String, String> headers) throws IOException {
        String requestPath;
        String requestMethod;
        Map requestParams;
        if ("raw".equals(apiName)) {
            HashMap<String, String> queryStringParams = new HashMap<String, String>(params);
            String method = (String)Objects.requireNonNull(queryStringParams.remove("method"), "Method must be set to use raw request");
            String path = "/" + (String)Objects.requireNonNull(queryStringParams.remove("path"), "Path must be set to use raw request");
            StringEntity entity = null;
            if (body != null && body.length() > 0) {
                entity = new StringEntity(body, ContentType.APPLICATION_JSON);
            }
            try {
                Response response = this.restClient.performRequest(method, path, queryStringParams, (HttpEntity)entity, new Header[0]);
                return new ClientYamlTestResponse(response);
            }
            catch (ResponseException e) {
                throw new ClientYamlTestResponseException(e);
            }
        }
        ArrayList<Integer> ignores = new ArrayList<Integer>();
        if (params == null) {
            requestParams = Collections.emptyMap();
        } else {
            String ignoreString;
            requestParams = new HashMap<String, String>(params);
            if (!params.isEmpty() && (ignoreString = (String)requestParams.remove("ignore")) != null) {
                try {
                    ignores.add(Integer.valueOf(ignoreString));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("ignore value should be a number, found [" + ignoreString + "] instead");
                }
            }
        }
        ClientYamlSuiteRestApi restApi = this.restApi(apiName);
        HashMap<String, String> pathParts = new HashMap<String, String>();
        HashMap queryStringParams = new HashMap();
        for (Map.Entry entry : requestParams.entrySet()) {
            if (restApi.getPathParts().contains(entry.getKey())) {
                pathParts.put((String)entry.getKey(), (String)entry.getValue());
                continue;
            }
            if (restApi.getParams().contains(entry.getKey()) || ALWAYS_ACCEPTED_QUERY_STRING_PARAMS.contains(entry.getKey())) {
                queryStringParams.put(entry.getKey(), entry.getValue());
                continue;
            }
            throw new IllegalArgumentException("param [" + (String)entry.getKey() + "] not supported in [" + restApi.getName() + "] api");
        }
        List<String> supportedMethods = restApi.getSupportedMethods(pathParts.keySet());
        StringEntity requestBody = null;
        if (Strings.hasLength((String)body)) {
            if (!restApi.isBodySupported()) {
                throw new IllegalArgumentException("body is not supported by [" + restApi.getName() + "] api");
            }
            if (supportedMethods.contains("GET") && RandomizedTest.rarely()) {
                logger.debug("sending the request body as source param with GET method");
                queryStringParams.put("source", body);
                requestMethod = "GET";
            } else {
                requestMethod = (String)RandomizedTest.randomFrom(supportedMethods);
                requestBody = new StringEntity(body, ContentType.APPLICATION_JSON);
            }
        } else {
            if (restApi.isBodyRequired()) {
                throw new IllegalArgumentException("body is required by [" + restApi.getName() + "] api");
            }
            requestMethod = (String)RandomizedTest.randomFrom(supportedMethods);
        }
        ClientYamlSuiteRestPath restPath = (ClientYamlSuiteRestPath)RandomizedTest.randomFrom((Object[])restApi.getFinalPaths(pathParts));
        if (restPath.getPathParts().length == 0) {
            requestPath = "/";
        } else {
            StringBuilder finalPath = new StringBuilder();
            for (String pathPart : restPath.getPathParts()) {
                try {
                    finalPath.append('/');
                    URI uri = new URI(null, null, null, -1, "/" + pathPart, null, null);
                    finalPath.append(uri.getRawPath().substring(1).replaceAll("/", "%2F"));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException("unable to build uri", e);
                }
            }
            requestPath = finalPath.toString();
        }
        Header[] requestHeaders = new Header[headers.size()];
        int index = 0;
        for (Map.Entry<String, String> header : headers.entrySet()) {
            logger.info("Adding header {}\n with value {}", (Object)header.getKey(), (Object)header.getValue());
            requestHeaders[index++] = new BasicHeader(header.getKey(), header.getValue());
        }
        logger.debug("calling api [{}]", (Object)apiName);
        try {
            Response response = this.restClient.performRequest(requestMethod, requestPath, queryStringParams, (HttpEntity)requestBody, requestHeaders);
            return new ClientYamlTestResponse(response);
        }
        catch (ResponseException e) {
            if (ignores.contains(e.getResponse().getStatusLine().getStatusCode())) {
                return new ClientYamlTestResponse(e.getResponse());
            }
            throw new ClientYamlTestResponseException(e);
        }
    }

    private ClientYamlSuiteRestApi restApi(String apiName) {
        ClientYamlSuiteRestApi restApi = this.restSpec.getApi(apiName);
        if (restApi == null) {
            throw new IllegalArgumentException("rest api [" + apiName + "] doesn't exist in the rest spec");
        }
        return restApi;
    }
}

