/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml.restspec;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.test.rest.yaml.FileUtils;
import org.elasticsearch.test.rest.yaml.restspec.ClientYamlSuiteRestApi;
import org.elasticsearch.test.rest.yaml.restspec.ClientYamlSuiteRestApiParser;

public class ClientYamlSuiteRestSpec {
    Map<String, ClientYamlSuiteRestApi> restApiMap = new HashMap<String, ClientYamlSuiteRestApi>();

    private ClientYamlSuiteRestSpec() {
    }

    void addApi(ClientYamlSuiteRestApi restApi) {
        ClientYamlSuiteRestApi previous = this.restApiMap.putIfAbsent(restApi.getName(), restApi);
        if (previous != null) {
            throw new IllegalArgumentException("cannot register api [" + restApi.getName() + "] found in [" + restApi.getLocation() + "]. api with same name was already found in [" + previous.getLocation() + "]");
        }
    }

    public ClientYamlSuiteRestApi getApi(String api) {
        return this.restApiMap.get(api);
    }

    public Collection<ClientYamlSuiteRestApi> getApis() {
        return this.restApiMap.values();
    }

    public static ClientYamlSuiteRestSpec parseFrom(FileSystem fileSystem, String optionalPathPrefix, String ... paths) throws IOException {
        ClientYamlSuiteRestSpec restSpec = new ClientYamlSuiteRestSpec();
        ClientYamlSuiteRestApiParser restApiParser = new ClientYamlSuiteRestApiParser();
        for (String path : paths) {
            for (Path jsonFile : FileUtils.findJsonSpec(fileSystem, optionalPathPrefix, path)) {
                try {
                    InputStream stream = Files.newInputStream(jsonFile, new OpenOption[0]);
                    Throwable throwable = null;
                    try {
                        XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, stream);
                        Throwable throwable2 = null;
                        try {
                            ClientYamlSuiteRestApi restApi = restApiParser.parse(jsonFile.toString(), parser);
                            String filename = jsonFile.getFileName().toString();
                            String expectedApiName = filename.substring(0, filename.lastIndexOf(46));
                            if (!restApi.getName().equals(expectedApiName)) {
                                throw new IllegalArgumentException("found api [" + restApi.getName() + "] in [" + jsonFile.toString() + "]. Each api is expected to have the same name as the file that defines it.");
                            }
                            restSpec.addApi(restApi);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (parser == null) continue;
                            if (throwable2 != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            parser.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (stream == null) continue;
                        if (throwable != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        stream.close();
                    }
                }
                catch (Exception ex) {
                    throw new IOException("Can't parse rest spec file: [" + jsonFile + "]", ex);
                }
            }
        }
        return restSpec;
    }
}

