/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterModule;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.EmptyClusterInfoService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.FailedShard;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.allocator.BalancedShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.cluster.routing.allocation.decider.SameShardAllocationDecider;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.LocalTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.gateway.GatewayAllocator;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.gateway.TestGatewayAllocator;

public abstract class ESAllocationTestCase
extends ESTestCase {
    private static final ClusterSettings EMPTY_CLUSTER_SETTINGS = new ClusterSettings(Settings.EMPTY, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS);
    protected static Set<DiscoveryNode.Role> MASTER_DATA_ROLES = Collections.unmodifiableSet(new HashSet<DiscoveryNode.Role>(Arrays.asList(DiscoveryNode.Role.MASTER, DiscoveryNode.Role.DATA)));

    public static MockAllocationService createAllocationService() {
        return ESAllocationTestCase.createAllocationService(Settings.Builder.EMPTY_SETTINGS);
    }

    public static MockAllocationService createAllocationService(Settings settings) {
        return ESAllocationTestCase.createAllocationService(settings, ESAllocationTestCase.random());
    }

    public static MockAllocationService createAllocationService(Settings settings, Random random) {
        return ESAllocationTestCase.createAllocationService(settings, EMPTY_CLUSTER_SETTINGS, random);
    }

    public static MockAllocationService createAllocationService(Settings settings, ClusterSettings clusterSettings, Random random) {
        return new MockAllocationService(settings, ESAllocationTestCase.randomAllocationDeciders(settings, clusterSettings, random), new TestGatewayAllocator(), (ShardsAllocator)new BalancedShardsAllocator(settings), (ClusterInfoService)EmptyClusterInfoService.INSTANCE);
    }

    public static MockAllocationService createAllocationService(Settings settings, ClusterInfoService clusterInfoService) {
        return new MockAllocationService(settings, ESAllocationTestCase.randomAllocationDeciders(settings, EMPTY_CLUSTER_SETTINGS, ESAllocationTestCase.random()), new TestGatewayAllocator(), (ShardsAllocator)new BalancedShardsAllocator(settings), clusterInfoService);
    }

    public static MockAllocationService createAllocationService(Settings settings, GatewayAllocator gatewayAllocator) {
        return new MockAllocationService(settings, ESAllocationTestCase.randomAllocationDeciders(settings, EMPTY_CLUSTER_SETTINGS, ESAllocationTestCase.random()), gatewayAllocator, (ShardsAllocator)new BalancedShardsAllocator(settings), (ClusterInfoService)EmptyClusterInfoService.INSTANCE);
    }

    public static AllocationDeciders randomAllocationDeciders(Settings settings, ClusterSettings clusterSettings, Random random) {
        ArrayList deciders = new ArrayList(ClusterModule.createAllocationDeciders((Settings)settings, (ClusterSettings)clusterSettings, Collections.emptyList()));
        Collections.shuffle(deciders, random);
        return new AllocationDeciders(settings, deciders);
    }

    protected static DiscoveryNode newNode(String nodeId) {
        return ESAllocationTestCase.newNode(nodeId, Version.CURRENT);
    }

    protected static DiscoveryNode newNode(String nodeName, String nodeId, Map<String, String> attributes) {
        return new DiscoveryNode(nodeName, nodeId, (TransportAddress)LocalTransportAddress.buildUnique(), attributes, MASTER_DATA_ROLES, Version.CURRENT);
    }

    protected static DiscoveryNode newNode(String nodeId, Map<String, String> attributes) {
        return new DiscoveryNode(nodeId, (TransportAddress)LocalTransportAddress.buildUnique(), attributes, MASTER_DATA_ROLES, Version.CURRENT);
    }

    protected static DiscoveryNode newNode(String nodeId, Set<DiscoveryNode.Role> roles) {
        return new DiscoveryNode(nodeId, (TransportAddress)LocalTransportAddress.buildUnique(), Collections.emptyMap(), roles, Version.CURRENT);
    }

    protected static DiscoveryNode newNode(String nodeId, Version version) {
        return new DiscoveryNode(nodeId, (TransportAddress)LocalTransportAddress.buildUnique(), Collections.emptyMap(), MASTER_DATA_ROLES, version);
    }

    protected static ClusterState startRandomInitializingShard(ClusterState clusterState, AllocationService strategy) {
        List initializingShards = clusterState.getRoutingNodes().shardsWithState(new ShardRoutingState[]{ShardRoutingState.INITIALIZING});
        if (initializingShards.isEmpty()) {
            return clusterState;
        }
        return strategy.applyStartedShards(clusterState, (List)CollectionUtils.arrayAsArrayList((Object[])new ShardRouting[]{(ShardRouting)initializingShards.get(ESAllocationTestCase.randomInt(initializingShards.size() - 1))}));
    }

    protected static AllocationDeciders yesAllocationDeciders() {
        return new AllocationDeciders(Settings.EMPTY, Arrays.asList(new AllocationDecider[]{new TestAllocateDecision(Decision.YES), new SameShardAllocationDecider(Settings.EMPTY)}));
    }

    protected static AllocationDeciders noAllocationDeciders() {
        return new AllocationDeciders(Settings.EMPTY, Collections.singleton(new TestAllocateDecision(Decision.NO)));
    }

    protected static AllocationDeciders throttleAllocationDeciders() {
        return new AllocationDeciders(Settings.EMPTY, Arrays.asList(new AllocationDecider[]{new TestAllocateDecision(Decision.THROTTLE), new SameShardAllocationDecider(Settings.EMPTY)}));
    }

    protected ClusterState applyStartedShardsUntilNoChange(ClusterState clusterState, AllocationService service) {
        ClusterState lastClusterState;
        do {
            lastClusterState = clusterState;
            this.logger.debug("ClusterState: {}", (Object)clusterState.getRoutingNodes());
        } while (!lastClusterState.equals(clusterState = service.applyStartedShards(clusterState, clusterState.getRoutingNodes().shardsWithState(new ShardRoutingState[]{ShardRoutingState.INITIALIZING}))));
        return clusterState;
    }

    protected static class DelayedShardsMockGatewayAllocator
    extends GatewayAllocator {
        public DelayedShardsMockGatewayAllocator() {
            super(Settings.EMPTY, null, null);
        }

        public void applyStartedShards(RoutingAllocation allocation, List<ShardRouting> startedShards) {
        }

        public void applyFailedShards(RoutingAllocation allocation, List<FailedShard> failedShards) {
        }

        public void allocateUnassigned(RoutingAllocation allocation) {
            RoutingNodes.UnassignedShards.UnassignedIterator unassignedIterator = allocation.routingNodes().unassigned().iterator();
            while (unassignedIterator.hasNext()) {
                ShardRouting shard = unassignedIterator.next();
                if (shard.primary() || shard.unassignedInfo().getReason() == UnassignedInfo.Reason.INDEX_CREATED || !shard.unassignedInfo().isDelayed()) continue;
                unassignedIterator.removeAndIgnore(UnassignedInfo.AllocationStatus.DELAYED_ALLOCATION, allocation.changes());
            }
        }
    }

    protected static class MockAllocationService
    extends AllocationService {
        private volatile long nanoTimeOverride = -1L;

        public MockAllocationService(Settings settings, AllocationDeciders allocationDeciders, GatewayAllocator gatewayAllocator, ShardsAllocator shardsAllocator, ClusterInfoService clusterInfoService) {
            super(settings, allocationDeciders, gatewayAllocator, shardsAllocator, clusterInfoService);
        }

        public void setNanoTimeOverride(long nanoTime) {
            this.nanoTimeOverride = nanoTime;
        }

        protected long currentNanoTime() {
            return this.nanoTimeOverride == -1L ? super.currentNanoTime() : this.nanoTimeOverride;
        }
    }

    public static class TestAllocateDecision
    extends AllocationDecider {
        private final Decision decision;

        public TestAllocateDecision(Decision decision) {
            super(Settings.EMPTY);
            this.decision = decision;
        }

        public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
            return this.decision;
        }

        public Decision canAllocate(ShardRouting shardRouting, RoutingAllocation allocation) {
            return this.decision;
        }

        public Decision canAllocate(RoutingNode node, RoutingAllocation allocation) {
            return this.decision;
        }
    }
}

