/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.node;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.network.NetworkModule;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.env.Environment;
import org.elasticsearch.node.MockNode;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeValidationException;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.InternalTestCluster;
import org.elasticsearch.transport.MockTcpTransportPlugin;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.mockito.Mockito;

public class NodeTests
extends ESTestCase {
    public void testNodeName() throws IOException {
        Path tempDir = NodeTests.createTempDir();
        String name = NodeTests.randomBoolean() ? NodeTests.randomAsciiOfLength(10) : null;
        Settings.Builder settings = Settings.builder().put(ClusterName.CLUSTER_NAME_SETTING.getKey(), InternalTestCluster.clusterName("single-node-cluster", NodeTests.randomLong())).put(new Object[]{Environment.PATH_HOME_SETTING.getKey(), tempDir}).put(NetworkModule.HTTP_ENABLED.getKey(), false).put("transport.type", "mock-socket-network").put(Node.NODE_DATA_SETTING.getKey(), true);
        if (name != null) {
            settings.put(Node.NODE_NAME_SETTING.getKey(), name);
        }
        try (MockNode node = new MockNode(settings.build(), Collections.singleton(MockTcpTransportPlugin.class));){
            Settings nodeSettings;
            Settings settings2 = nodeSettings = NodeTests.randomBoolean() ? node.settings() : node.getEnvironment().settings();
            if (name == null) {
                NodeTests.assertThat((Object)Node.NODE_NAME_SETTING.get(nodeSettings), (Matcher)Matchers.equalTo((Object)node.getNodeEnvironment().nodeId().substring(0, 7)));
            } else {
                NodeTests.assertThat((Object)Node.NODE_NAME_SETTING.get(nodeSettings), (Matcher)Matchers.equalTo((Object)name));
            }
        }
    }

    public void testLoadPluginBootstrapChecks() throws IOException {
        Path tempDir = NodeTests.createTempDir();
        String name = NodeTests.randomBoolean() ? NodeTests.randomAsciiOfLength(10) : null;
        Settings.Builder settings = Settings.builder().put(ClusterName.CLUSTER_NAME_SETTING.getKey(), InternalTestCluster.clusterName("single-node-cluster", NodeTests.randomLong())).put(new Object[]{Environment.PATH_HOME_SETTING.getKey(), tempDir}).put(NetworkModule.HTTP_ENABLED.getKey(), false).put("transport.type", "mock-socket-network").put(Node.NODE_DATA_SETTING.getKey(), true);
        if (name != null) {
            settings.put(Node.NODE_NAME_SETTING.getKey(), name);
        }
        final AtomicBoolean executed = new AtomicBoolean(false);
        try (MockNode node = new MockNode(settings.build(), Arrays.asList(MockTcpTransportPlugin.class, CheckPlugin.class)){

            protected void validateNodeBeforeAcceptingRequests(Settings settings, BoundTransportAddress boundTransportAddress, List<BootstrapCheck> bootstrapChecks) throws NodeValidationException {
                Assert.assertEquals((long)1L, (long)bootstrapChecks.size());
                Assert.assertSame((Object)CheckPlugin.CHECK, (Object)bootstrapChecks.get(0));
                executed.set(true);
                throw new NodeValidationException("boom");
            }
        };){
            NodeTests.expectThrows(NodeValidationException.class, () -> node.start());
            NodeTests.assertTrue((boolean)executed.get());
        }
    }

    public void testWarnIfPreRelease() {
        Logger logger = (Logger)Mockito.mock(Logger.class);
        int id = NodeTests.randomIntBetween(1, 9) * 1000000;
        Version releaseVersion = Version.fromId((int)(id + 99));
        Version preReleaseVersion = Version.fromId((int)(id + NodeTests.randomIntBetween(0, 98)));
        Node.warnIfPreRelease((Version)releaseVersion, (boolean)false, (Logger)logger);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{logger});
        Mockito.reset((Object[])new Logger[]{logger});
        Node.warnIfPreRelease((Version)releaseVersion, (boolean)true, (Logger)logger);
        ((Logger)Mockito.verify((Object)logger)).warn("version [{}] is a pre-release version of Elasticsearch and is not suitable for production", (Object)(releaseVersion + "-SNAPSHOT"));
        Mockito.reset((Object[])new Logger[]{logger});
        boolean isSnapshot = NodeTests.randomBoolean();
        Node.warnIfPreRelease((Version)preReleaseVersion, (boolean)isSnapshot, (Logger)logger);
        ((Logger)Mockito.verify((Object)logger)).warn("version [{}] is a pre-release version of Elasticsearch and is not suitable for production", (Object)(preReleaseVersion + (isSnapshot ? "-SNAPSHOT" : "")));
    }

    public static class CheckPlugin
    extends Plugin {
        public static final BootstrapCheck CHECK = new BootstrapCheck(){

            public boolean check() {
                return false;
            }

            public String errorMessage() {
                return "boom";
            }
        };

        public List<BootstrapCheck> getBootstrapChecks() {
            return Collections.singletonList(CHECK);
        }
    }
}

