/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.FilterClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.test.ExternalNode;
import org.elasticsearch.test.InternalTestCluster;
import org.elasticsearch.test.TestCluster;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class CompositeTestCluster
extends TestCluster {
    private final InternalTestCluster cluster;
    private final ExternalNode[] externalNodes;
    private final ExternalClient client = new ExternalClient();
    private static final String NODE_PREFIX = "external_";

    public CompositeTestCluster(InternalTestCluster cluster, int numExternalNodes, ExternalNode externalNode) throws IOException {
        super(cluster.seed());
        this.cluster = cluster;
        this.externalNodes = new ExternalNode[numExternalNodes];
        for (int i = 0; i < this.externalNodes.length; ++i) {
            this.externalNodes[i] = externalNode;
        }
    }

    @Override
    public synchronized void afterTest() throws IOException {
        this.cluster.afterTest();
    }

    @Override
    public synchronized void beforeTest(Random random, double transportClientRatio) throws IOException, InterruptedException {
        super.beforeTest(random, transportClientRatio);
        this.cluster.beforeTest(random, transportClientRatio);
        Settings defaultSettings = this.cluster.getDefaultSettings();
        Client client = this.cluster.size() > 0 ? this.cluster.client() : this.cluster.coordOnlyNodeClient();
        for (int i = 0; i < this.externalNodes.length; ++i) {
            if (!this.externalNodes[i].running()) {
                this.externalNodes[i] = this.externalNodes[i].start(client, defaultSettings, NODE_PREFIX + i, this.cluster.getClusterName(), i);
            }
            this.externalNodes[i].reset(random.nextLong());
        }
        if (this.size() > 0) {
            this.client().admin().cluster().prepareHealth(new String[0]).setWaitForNodes(">=" + Integer.toString(this.size())).get();
        }
    }

    private Collection<ExternalNode> runningNodes() {
        return Arrays.stream(this.externalNodes).filter(input -> input.running()).collect(Collectors.toCollection(ArrayList::new));
    }

    public synchronized boolean upgradeOneNode() throws InterruptedException, IOException {
        return this.upgradeOneNode(Settings.EMPTY);
    }

    public synchronized boolean upgradeAllNodes() throws InterruptedException, IOException {
        return this.upgradeAllNodes(Settings.EMPTY);
    }

    public synchronized boolean upgradeAllNodes(Settings nodeSettings) throws InterruptedException, IOException {
        boolean upgradedOneNode = false;
        while (this.upgradeOneNode(nodeSettings)) {
            upgradedOneNode = true;
        }
        return upgradedOneNode;
    }

    public synchronized boolean upgradeOneNode(Settings nodeSettings) throws InterruptedException, IOException {
        Collection<ExternalNode> runningNodes = this.runningNodes();
        if (!runningNodes.isEmpty()) {
            Client existingClient = this.cluster.client();
            ExternalNode externalNode = (ExternalNode)RandomPicks.randomFrom((Random)this.random, runningNodes);
            externalNode.stop();
            String s = this.cluster.startNode(nodeSettings);
            ExternalNode.waitForNode(existingClient, s);
            ElasticsearchAssertions.assertNoTimeout((ClusterHealthResponse)existingClient.admin().cluster().prepareHealth(new String[0]).setWaitForNodes(Integer.toString(this.size())).get());
            return true;
        }
        return false;
    }

    public String newNodePattern() {
        return this.cluster.nodePrefix() + "*";
    }

    public String backwardsNodePattern() {
        return "external_*";
    }

    public void allowOnAllNodes(String ... index) {
        Settings build = Settings.builder().put("index.routing.allocation.exclude._name", "").build();
        this.client().admin().indices().prepareUpdateSettings(index).setSettings(build).execute().actionGet();
    }

    public void allowOnlyNewNodes(String ... index) {
        Settings build = Settings.builder().put("index.routing.allocation.exclude._name", this.backwardsNodePattern()).build();
        this.client().admin().indices().prepareUpdateSettings(index).setSettings(build).execute().actionGet();
    }

    public void startNewNode() {
        this.cluster.startNode();
    }

    @Override
    public synchronized Client client() {
        return this.client;
    }

    @Override
    public synchronized int size() {
        return this.runningNodes().size() + this.cluster.size();
    }

    @Override
    public int numDataNodes() {
        return this.runningNodes().size() + this.cluster.numDataNodes();
    }

    @Override
    public int numDataAndMasterNodes() {
        return this.runningNodes().size() + this.cluster.numDataAndMasterNodes();
    }

    @Override
    public InetSocketAddress[] httpAddresses() {
        return this.cluster.httpAddresses();
    }

    @Override
    public void close() throws IOException {
        try {
            IOUtils.close((Closeable[])this.externalNodes);
        }
        catch (Throwable throwable) {
            IOUtils.close((Closeable[])new Closeable[]{this.cluster});
            throw throwable;
        }
        IOUtils.close((Closeable[])new Closeable[]{this.cluster});
    }

    @Override
    public void ensureEstimatedStats() {
        if (this.size() > 0) {
            NodesStatsResponse nodeStats = (NodesStatsResponse)this.client().admin().cluster().prepareNodesStats(new String[0]).clear().setBreaker(true).execute().actionGet();
            for (NodeStats stats : nodeStats.getNodes()) {
                Assert.assertThat((String)("Fielddata breaker not reset to 0 on node: " + stats.getNode()), (Object)stats.getBreaker().getStats("fielddata").getEstimated(), (Matcher)Matchers.equalTo((Object)0L));
            }
        }
    }

    @Override
    public String getClusterName() {
        return this.cluster.getClusterName();
    }

    @Override
    public synchronized Iterable<Client> getClients() {
        return Collections.singleton(this.client());
    }

    public void fullRestartInternalCluster() throws Exception {
        this.cluster.fullRestart();
    }

    public int numNewDataNodes() {
        return this.cluster.numDataNodes();
    }

    public int numBackwardsDataNodes() {
        return this.runningNodes().size();
    }

    public TransportAddress externalTransportAddress() {
        return ((ExternalNode)RandomPicks.randomFrom((Random)this.random, (Object[])this.externalNodes)).getTransportAddress();
    }

    public InternalTestCluster internalCluster() {
        return this.cluster;
    }

    private synchronized Client internalClient() {
        Collection<ExternalNode> externalNodes = this.runningNodes();
        return this.random.nextBoolean() && !externalNodes.isEmpty() ? ((ExternalNode)RandomPicks.randomFrom((Random)this.random, externalNodes)).getClient() : this.cluster.client();
    }

    private final class ExternalClient
    extends FilterClient {
        public ExternalClient() {
            super(CompositeTestCluster.this.internalClient());
        }

        public void close() {
        }
    }
}

