/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.rest.RestRequest;

public class FakeRestRequest
extends RestRequest {
    private final Map<String, String> headers;
    private final BytesReference content;
    private final RestRequest.Method method;

    public FakeRestRequest() {
        this(NamedXContentRegistry.EMPTY, new HashMap<String, String>(), new HashMap<String, String>(), null, RestRequest.Method.GET, "/");
    }

    private FakeRestRequest(NamedXContentRegistry xContentRegistry, Map<String, String> headers, Map<String, String> params, BytesReference content, RestRequest.Method method, String path) {
        super(xContentRegistry, params, path);
        this.headers = headers;
        this.content = content;
        this.method = method;
    }

    public RestRequest.Method method() {
        return this.method;
    }

    public String uri() {
        return this.rawPath();
    }

    public boolean hasContent() {
        return this.content != null;
    }

    public BytesReference content() {
        return this.content;
    }

    public String header(String name) {
        return this.headers.get(name);
    }

    public Iterable<Map.Entry<String, String>> headers() {
        return this.headers.entrySet();
    }

    public static class Builder {
        private final NamedXContentRegistry xContentRegistry;
        private Map<String, String> headers = new HashMap<String, String>();
        private Map<String, String> params = new HashMap<String, String>();
        private BytesReference content;
        private String path = "/";
        private RestRequest.Method method = RestRequest.Method.GET;

        public Builder(NamedXContentRegistry xContentRegistry) {
            this.xContentRegistry = xContentRegistry;
        }

        public Builder withHeaders(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder withParams(Map<String, String> params) {
            this.params = params;
            return this;
        }

        public Builder withContent(BytesReference content) {
            this.content = content;
            return this;
        }

        public Builder withPath(String path) {
            this.path = path;
            return this;
        }

        public Builder withMethod(RestRequest.Method method) {
            this.method = method;
            return this;
        }

        public FakeRestRequest build() {
            return new FakeRestRequest(this.xContentRegistry, this.headers, this.params, this.content, this.method, this.path);
        }
    }
}

