/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.PathUtils;

public final class FileUtils {
    private static final String YAML_SUFFIX = ".yaml";
    private static final String JSON_SUFFIX = ".json";

    private FileUtils() {
    }

    public static Set<Path> findJsonSpec(FileSystem fileSystem, String optionalPathPrefix, String path) throws IOException {
        Path dir = FileUtils.resolveFile(fileSystem, optionalPathPrefix, path, null);
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new NotDirectoryException(path);
        }
        HashSet<Path> jsonFiles = new HashSet<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path item : stream) {
                if (!item.toString().endsWith(JSON_SUFFIX)) continue;
                jsonFiles.add(item);
            }
        }
        if (jsonFiles.isEmpty()) {
            throw new NoSuchFileException(path, null, "no json files found");
        }
        return jsonFiles;
    }

    public static Map<String, Set<Path>> findYamlSuites(FileSystem fileSystem, String optionalPathPrefix, String ... paths) throws IOException {
        HashMap<String, Set<Path>> yamlSuites = new HashMap<String, Set<Path>>();
        for (String path : paths) {
            FileUtils.collectFiles(FileUtils.resolveFile(fileSystem, optionalPathPrefix, path, YAML_SUFFIX), YAML_SUFFIX, yamlSuites);
        }
        return yamlSuites;
    }

    private static Path resolveFile(FileSystem fileSystem, String optionalPathPrefix, String path, String optionalFileSuffix) throws IOException {
        String newPath;
        if (fileSystem != null) {
            String newPath2;
            Path file = FileUtils.findFile(fileSystem, path, optionalFileSuffix);
            if (!FileUtils.lenientExists(file) && !FileUtils.lenientExists(file = FileUtils.findFile(fileSystem, newPath2 = optionalPathPrefix + "/" + path, optionalFileSuffix))) {
                throw new NoSuchFileException("path prefix: " + optionalPathPrefix + ", path: " + path + ", file suffix: " + optionalFileSuffix);
            }
            return file;
        }
        URL resource = FileUtils.findResource(path, optionalFileSuffix);
        if (resource == null && (resource = FileUtils.findResource(newPath = optionalPathPrefix + "/" + path, optionalFileSuffix)) == null) {
            throw new NoSuchFileException(path);
        }
        try {
            return PathUtils.get((URI)resource.toURI());
        }
        catch (Exception e) {
            throw new RuntimeException("couldn't retrieve URL: " + resource, e);
        }
    }

    private static URL findResource(String path, String optionalFileSuffix) {
        URL resource = FileUtils.class.getResource(path);
        if (resource == null && Strings.hasLength((String)optionalFileSuffix) && !path.endsWith(optionalFileSuffix)) {
            resource = FileUtils.class.getResource(path + optionalFileSuffix);
        }
        return resource;
    }

    private static boolean lenientExists(Path file) {
        boolean exists = false;
        try {
            exists = Files.exists(file, new LinkOption[0]);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return exists;
    }

    private static Path findFile(FileSystem fileSystem, String path, String optionalFileSuffix) {
        Path file = fileSystem.getPath(path, new String[0]);
        if (!FileUtils.lenientExists(file)) {
            file = fileSystem.getPath(path + optionalFileSuffix, new String[0]);
        }
        return file;
    }

    private static void collectFiles(final Path dir, final String fileSuffix, final Map<String, Set<Path>> files) throws IOException {
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.toString().endsWith(fileSuffix)) {
                    String groupName = dir.relativize(file.getParent()).toString();
                    HashSet<Path> filesSet = (HashSet<Path>)files.get(groupName);
                    if (filesSet == null) {
                        filesSet = new HashSet<Path>();
                        files.put(groupName, filesSet);
                    }
                    filesSet.add(file);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

