/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml.restspec;

import java.io.IOException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.test.rest.yaml.restspec.ClientYamlSuiteRestApi;

public class ClientYamlSuiteRestApiParser {
    public ClientYamlSuiteRestApi parse(String location, XContentParser parser) throws IOException {
        while (parser.nextToken() != XContentParser.Token.FIELD_NAME) {
        }
        ClientYamlSuiteRestApi restApi = new ClientYamlSuiteRestApi(location, parser.currentName());
        int level = -1;
        while (parser.nextToken() != XContentParser.Token.END_OBJECT || level >= 0) {
            if (parser.currentToken() == XContentParser.Token.FIELD_NAME) {
                if ("methods".equals(parser.currentName())) {
                    parser.nextToken();
                    while (parser.nextToken() == XContentParser.Token.VALUE_STRING) {
                        String method = parser.text();
                        if (restApi.getMethods().contains(method)) {
                            throw new IllegalArgumentException("Found duplicate method [" + method + "]");
                        }
                        restApi.addMethod(method);
                    }
                }
                if ("url".equals(parser.currentName())) {
                    String currentFieldName = "url";
                    int innerLevel = -1;
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT || innerLevel >= 0) {
                        if (parser.currentToken() == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                        }
                        if (parser.currentToken() == XContentParser.Token.START_ARRAY && "paths".equals(currentFieldName)) {
                            while (parser.nextToken() == XContentParser.Token.VALUE_STRING) {
                                String path = parser.text();
                                if (restApi.getPaths().contains(path)) {
                                    throw new IllegalArgumentException("Found duplicate path [" + path + "]");
                                }
                                restApi.addPath(path);
                            }
                        }
                        if (parser.currentToken() == XContentParser.Token.START_OBJECT && "parts".equals(currentFieldName)) {
                            while (parser.nextToken() == XContentParser.Token.FIELD_NAME) {
                                String part = parser.currentName();
                                if (restApi.getPathParts().contains(part)) {
                                    throw new IllegalArgumentException("Found duplicate part [" + part + "]");
                                }
                                restApi.addPathPart(part);
                                parser.nextToken();
                                if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
                                    throw new IllegalArgumentException("Expected parts field in rest api definition to contain an object");
                                }
                                parser.skipChildren();
                            }
                        }
                        if (parser.currentToken() == XContentParser.Token.START_OBJECT && "params".equals(currentFieldName)) {
                            while (parser.nextToken() == XContentParser.Token.FIELD_NAME) {
                                String param = parser.currentName();
                                if (restApi.getParams().contains(param)) {
                                    throw new IllegalArgumentException("Found duplicate param [" + param + "]");
                                }
                                restApi.addParam(parser.currentName());
                                parser.nextToken();
                                if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
                                    throw new IllegalArgumentException("Expected params field in rest api definition to contain an object");
                                }
                                parser.skipChildren();
                            }
                        }
                        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                            ++innerLevel;
                        }
                        if (parser.currentToken() != XContentParser.Token.END_OBJECT) continue;
                        --innerLevel;
                    }
                }
                if ("body".equals(parser.currentName())) {
                    parser.nextToken();
                    if (parser.currentToken() != XContentParser.Token.VALUE_NULL) {
                        boolean requiredFound = false;
                        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                            if (parser.currentToken() != XContentParser.Token.FIELD_NAME || !"required".equals(parser.currentName())) continue;
                            requiredFound = true;
                            parser.nextToken();
                            if (parser.booleanValue()) {
                                restApi.setBodyRequired();
                                continue;
                            }
                            restApi.setBodyOptional();
                        }
                        if (!requiredFound) {
                            restApi.setBodyOptional();
                        }
                    }
                }
            }
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                ++level;
            }
            if (parser.currentToken() != XContentParser.Token.END_OBJECT) continue;
            --level;
        }
        parser.nextToken();
        assert (parser.currentToken() == XContentParser.Token.END_OBJECT) : "Expected [END_OBJECT] but was [" + parser.currentToken() + "]";
        parser.nextToken();
        return restApi;
    }
}

