/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml.section;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.test.rest.yaml.section.DoSection;
import org.elasticsearch.test.rest.yaml.section.ParserUtils;
import org.elasticsearch.test.rest.yaml.section.SkipSection;

public class TeardownSection {
    public static final TeardownSection EMPTY = new TeardownSection();
    private SkipSection skipSection;
    private List<DoSection> doSections = new ArrayList<DoSection>();

    public static TeardownSection parseIfNext(XContentParser parser) throws IOException {
        ParserUtils.advanceToFieldName(parser);
        if ("teardown".equals(parser.currentName())) {
            parser.nextToken();
            TeardownSection section = TeardownSection.parse(parser);
            parser.nextToken();
            return section;
        }
        return EMPTY;
    }

    public static TeardownSection parse(XContentParser parser) throws IOException {
        TeardownSection teardownSection = new TeardownSection();
        teardownSection.setSkipSection(SkipSection.parseIfNext(parser));
        while (parser.currentToken() != XContentParser.Token.END_ARRAY) {
            ParserUtils.advanceToFieldName(parser);
            if (!"do".equals(parser.currentName())) {
                throw new ParsingException(parser.getTokenLocation(), "section [" + parser.currentName() + "] not supported within teardown section", new Object[0]);
            }
            parser.nextToken();
            teardownSection.addDoSection(DoSection.parse(parser));
            parser.nextToken();
        }
        parser.nextToken();
        return teardownSection;
    }

    public SkipSection getSkipSection() {
        return this.skipSection;
    }

    public void setSkipSection(SkipSection skipSection) {
        this.skipSection = skipSection;
    }

    public List<DoSection> getDoSections() {
        return this.doSections;
    }

    public void addDoSection(DoSection doSection) {
        this.doSections.add(doSection);
    }

    public boolean isEmpty() {
        return EMPTY.equals(this);
    }

    static {
        EMPTY.setSkipSection(SkipSection.EMPTY);
    }
}

