/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.transport;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.util.LuceneTestCase;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.SendRequestTransportException;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportServiceAdapter;

public class CapturingTransport
implements Transport {
    private TransportServiceAdapter adapter;
    private ConcurrentMap<Long, Tuple<DiscoveryNode, String>> requests = new ConcurrentHashMap<Long, Tuple<DiscoveryNode, String>>();
    private BlockingQueue<CapturedRequest> capturedRequests = ConcurrentCollections.newBlockingQueue();
    private final AtomicLong requestId = new AtomicLong();

    public CapturedRequest[] capturedRequests() {
        return this.capturedRequests.toArray(new CapturedRequest[0]);
    }

    public CapturedRequest[] getCapturedRequestsAndClear() {
        CapturedRequest[] capturedRequests = this.capturedRequests();
        this.clear();
        return capturedRequests;
    }

    public Map<String, List<CapturedRequest>> capturedRequestsByTargetNode() {
        HashMap<String, List<CapturedRequest>> map = new HashMap<String, List<CapturedRequest>>();
        for (CapturedRequest request : this.capturedRequests) {
            ArrayList<CapturedRequest> nodeList = (ArrayList<CapturedRequest>)map.get(request.node.getId());
            if (nodeList == null) {
                nodeList = new ArrayList<CapturedRequest>();
                map.put(request.node.getId(), nodeList);
            }
            nodeList.add(request);
        }
        return map;
    }

    public Map<String, List<CapturedRequest>> getCapturedRequestsByTargetNodeAndClear() {
        Map<String, List<CapturedRequest>> map = this.capturedRequestsByTargetNode();
        this.clear();
        return map;
    }

    public void clear() {
        this.capturedRequests.clear();
    }

    public void handleResponse(long requestId, TransportResponse response) {
        this.adapter.onResponseReceived(requestId).handleResponse(response);
    }

    public void handleLocalError(long requestId, Throwable t) {
        Tuple request = (Tuple)this.requests.get(requestId);
        assert (request != null);
        this.handleError(requestId, (TransportException)new SendRequestTransportException((DiscoveryNode)request.v1(), (String)request.v2(), t));
    }

    public void handleRemoteError(long requestId, Throwable t) {
        RemoteTransportException remoteException;
        if (LuceneTestCase.rarely((Random)Randomness.get())) {
            remoteException = new RemoteTransportException("remote failure, coming from local node", t);
        } else {
            try (BytesStreamOutput output = new BytesStreamOutput();){
                output.writeException(t);
                remoteException = new RemoteTransportException("remote failure", (Throwable)output.bytes().streamInput().readException());
            }
            catch (IOException ioException) {
                throw new ElasticsearchException("failed to serialize/deserialize supplied exception " + t, (Throwable)ioException, new Object[0]);
            }
        }
        this.handleError(requestId, (TransportException)remoteException);
    }

    public void handleError(long requestId, TransportException e) {
        this.adapter.onResponseReceived(requestId).handleException(e);
    }

    public Transport.Connection openConnection(final DiscoveryNode node, ConnectionProfile profile) throws IOException {
        return new Transport.Connection(){

            public DiscoveryNode getNode() {
                return node;
            }

            public void sendRequest(long requestId, String action, TransportRequest request, TransportRequestOptions options) throws IOException, TransportException {
                CapturingTransport.this.requests.put(requestId, Tuple.tuple((Object)node, (Object)action));
                CapturingTransport.this.capturedRequests.add(new CapturedRequest(node, requestId, action, request));
            }

            public void close() throws IOException {
            }
        };
    }

    public void transportServiceAdapter(TransportServiceAdapter adapter) {
        this.adapter = adapter;
    }

    public BoundTransportAddress boundAddress() {
        return null;
    }

    public Map<String, BoundTransportAddress> profileBoundAddresses() {
        return null;
    }

    public TransportAddress[] addressesFromString(String address, int perAddressLimit) throws UnknownHostException {
        return new TransportAddress[0];
    }

    public boolean addressSupported(Class<? extends TransportAddress> address) {
        return false;
    }

    public boolean nodeConnected(DiscoveryNode node) {
        return true;
    }

    public void connectToNode(DiscoveryNode node, ConnectionProfile connectionProfile) throws ConnectTransportException {
    }

    public void disconnectFromNode(DiscoveryNode node) {
    }

    public long serverOpen() {
        return 0L;
    }

    public Lifecycle.State lifecycleState() {
        return null;
    }

    public void addLifecycleListener(LifecycleListener listener) {
    }

    public void removeLifecycleListener(LifecycleListener listener) {
    }

    public void start() {
    }

    public void stop() {
    }

    public void close() {
    }

    public List<String> getLocalAddresses() {
        return Collections.emptyList();
    }

    public long newRequestId() {
        return this.requestId.incrementAndGet();
    }

    public Transport.Connection getConnection(DiscoveryNode node) {
        try {
            return this.openConnection(node, null);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static class CapturedRequest {
        public final DiscoveryNode node;
        public final long requestId;
        public final String action;
        public final TransportRequest request;

        public CapturedRequest(DiscoveryNode node, long requestId, String action, TransportRequest request) {
            this.node = node;
            this.requestId = requestId;
            this.action = action;
            this.request = request;
        }
    }
}

