/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import com.carrotsearch.randomizedtesting.generators.RandomNumbers;
import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import com.carrotsearch.randomizedtesting.generators.RandomStrings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.elasticsearch.ingest.IngestDocument;

public final class RandomDocumentPicks {
    private RandomDocumentPicks() {
    }

    public static String randomFieldName(Random random) {
        int numLevels = RandomNumbers.randomIntBetween((Random)random, (int)1, (int)5);
        String fieldName = "";
        for (int i = 0; i < numLevels; ++i) {
            if (i > 0) {
                fieldName = fieldName + ".";
            }
            fieldName = fieldName + RandomDocumentPicks.randomString(random);
        }
        return fieldName;
    }

    public static String randomLeafFieldName(Random random) {
        String fieldName;
        while ((fieldName = RandomDocumentPicks.randomString(random)).contains(".")) {
        }
        return fieldName;
    }

    public static String randomExistingFieldName(Random random, IngestDocument ingestDocument) {
        TreeMap source = new TreeMap(ingestDocument.getSourceAndMetadata());
        Map.Entry randomEntry = (Map.Entry)RandomPicks.randomFrom((Random)random, source.entrySet());
        String key = (String)randomEntry.getKey();
        while (randomEntry.getValue() instanceof Map) {
            Map map = (Map)randomEntry.getValue();
            TreeMap treeMap = new TreeMap(map);
            randomEntry = (Map.Entry)RandomPicks.randomFrom((Random)random, treeMap.entrySet());
            key = key + "." + (String)randomEntry.getKey();
        }
        assert (ingestDocument.getFieldValue(key, Object.class) != null);
        return key;
    }

    public static String addRandomField(Random random, IngestDocument ingestDocument, Object value) {
        String fieldName;
        while (!RandomDocumentPicks.canAddField(fieldName = RandomDocumentPicks.randomFieldName(random), ingestDocument)) {
        }
        ingestDocument.setFieldValue(fieldName, value);
        return fieldName;
    }

    public static boolean canAddField(String path, IngestDocument ingestDocument) {
        String leafKey;
        String[] pathElements = path.split("\\.");
        Map innerMap = ingestDocument.getSourceAndMetadata();
        if (pathElements.length > 1) {
            for (int i = 0; i < pathElements.length - 1; ++i) {
                Map map;
                Object currentLevel = innerMap.get(pathElements[i]);
                if (currentLevel == null) {
                    return true;
                }
                if (!(currentLevel instanceof Map)) {
                    return false;
                }
                innerMap = map = (Map)currentLevel;
            }
        }
        return !innerMap.containsKey(leafKey = pathElements[pathElements.length - 1]);
    }

    public static IngestDocument randomIngestDocument(Random random) {
        return RandomDocumentPicks.randomIngestDocument(random, RandomDocumentPicks.randomSource(random));
    }

    public static IngestDocument randomIngestDocument(Random random, Map<String, Object> source) {
        String index = RandomDocumentPicks.randomString(random);
        String type = RandomDocumentPicks.randomString(random);
        String id = RandomDocumentPicks.randomString(random);
        String routing = null;
        if (random.nextBoolean()) {
            routing = RandomDocumentPicks.randomString(random);
        }
        String parent = null;
        if (random.nextBoolean()) {
            parent = RandomDocumentPicks.randomString(random);
        }
        String timestamp = null;
        if (random.nextBoolean()) {
            timestamp = RandomDocumentPicks.randomString(random);
        }
        String ttl = null;
        if (random.nextBoolean()) {
            ttl = RandomDocumentPicks.randomString(random);
        }
        return new IngestDocument(index, type, id, routing, parent, timestamp, ttl, source);
    }

    public static Map<String, Object> randomSource(Random random) {
        HashMap<String, Object> document = new HashMap<String, Object>();
        RandomDocumentPicks.addRandomFields(random, document, 0);
        return document;
    }

    public static Object randomFieldValue(Random random) {
        return RandomDocumentPicks.randomFieldValue(random, 0);
    }

    private static Object randomFieldValue(Random random, int currentDepth) {
        switch (RandomNumbers.randomIntBetween((Random)random, (int)0, (int)9)) {
            case 0: {
                return RandomDocumentPicks.randomString(random);
            }
            case 1: {
                return random.nextInt();
            }
            case 2: {
                return random.nextBoolean();
            }
            case 3: {
                return random.nextDouble();
            }
            case 4: {
                ArrayList<String> stringList = new ArrayList<String>();
                int numStringItems = RandomNumbers.randomIntBetween((Random)random, (int)1, (int)10);
                for (int j = 0; j < numStringItems; ++j) {
                    stringList.add(RandomDocumentPicks.randomString(random));
                }
                return stringList;
            }
            case 5: {
                ArrayList<Integer> intList = new ArrayList<Integer>();
                int numIntItems = RandomNumbers.randomIntBetween((Random)random, (int)1, (int)10);
                for (int j = 0; j < numIntItems; ++j) {
                    intList.add(random.nextInt());
                }
                return intList;
            }
            case 6: {
                ArrayList<Boolean> booleanList = new ArrayList<Boolean>();
                int numBooleanItems = RandomNumbers.randomIntBetween((Random)random, (int)1, (int)10);
                for (int j = 0; j < numBooleanItems; ++j) {
                    booleanList.add(random.nextBoolean());
                }
                return booleanList;
            }
            case 7: {
                ArrayList<Double> doubleList = new ArrayList<Double>();
                int numDoubleItems = RandomNumbers.randomIntBetween((Random)random, (int)1, (int)10);
                for (int j = 0; j < numDoubleItems; ++j) {
                    doubleList.add(random.nextDouble());
                }
                return doubleList;
            }
            case 8: {
                HashMap<String, Object> newNode = new HashMap<String, Object>();
                RandomDocumentPicks.addRandomFields(random, newNode, ++currentDepth);
                return newNode;
            }
            case 9: {
                byte[] byteArray = new byte[RandomNumbers.randomIntBetween((Random)random, (int)1, (int)1024)];
                random.nextBytes(byteArray);
                return byteArray;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static String randomString(Random random) {
        if (random.nextBoolean()) {
            return RandomStrings.randomAsciiOfLengthBetween((Random)random, (int)1, (int)10);
        }
        return RandomStrings.randomUnicodeOfCodepointLengthBetween((Random)random, (int)1, (int)10);
    }

    private static void addRandomFields(Random random, Map<String, Object> parentNode, int currentDepth) {
        if (currentDepth > 5) {
            return;
        }
        int numFields = RandomNumbers.randomIntBetween((Random)random, (int)1, (int)10);
        for (int i = 0; i < numFields; ++i) {
            String fieldName = RandomDocumentPicks.randomLeafFieldName(random);
            Object fieldValue = RandomDocumentPicks.randomFieldValue(random, currentDepth);
            parentNode.put(fieldName, fieldValue);
        }
    }
}

