/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.io.IOException;
import java.io.InputStream;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.test.ESTestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public abstract class ESBlobStoreTestCase
extends ESTestCase {
    public void testContainerCreationAndDeletion() throws IOException {
        try (BlobStore store = this.newBlobStore();){
            BlobContainer containerFoo = store.blobContainer(new BlobPath().add("foo"));
            BlobContainer containerBar = store.blobContainer(new BlobPath().add("bar"));
            byte[] data1 = ESBlobStoreTestCase.randomBytes(ESBlobStoreTestCase.randomIntBetween(10, ESBlobStoreTestCase.scaledRandomIntBetween(1024, 65536)));
            byte[] data2 = ESBlobStoreTestCase.randomBytes(ESBlobStoreTestCase.randomIntBetween(10, ESBlobStoreTestCase.scaledRandomIntBetween(1024, 65536)));
            ESBlobStoreTestCase.writeBlob(containerFoo, "test", new BytesArray(data1));
            ESBlobStoreTestCase.writeBlob(containerBar, "test", new BytesArray(data2));
            ESBlobStoreTestCase.assertArrayEquals((byte[])ESBlobStoreTestCase.readBlobFully(containerFoo, "test", data1.length), (byte[])data1);
            ESBlobStoreTestCase.assertArrayEquals((byte[])ESBlobStoreTestCase.readBlobFully(containerBar, "test", data2.length), (byte[])data2);
            ESBlobStoreTestCase.assertTrue((boolean)containerFoo.blobExists("test"));
            ESBlobStoreTestCase.assertTrue((boolean)containerBar.blobExists("test"));
            store.delete(new BlobPath());
            ESBlobStoreTestCase.assertFalse((boolean)containerFoo.blobExists("test"));
            ESBlobStoreTestCase.assertFalse((boolean)containerBar.blobExists("test"));
        }
    }

    public static byte[] writeRandomBlob(BlobContainer container, String name, int length) throws IOException {
        byte[] data = ESBlobStoreTestCase.randomBytes(length);
        ESBlobStoreTestCase.writeBlob(container, name, new BytesArray(data));
        return data;
    }

    public static byte[] readBlobFully(BlobContainer container, String name, int length) throws IOException {
        byte[] data = new byte[length];
        try (InputStream inputStream = container.readBlob(name);){
            ESBlobStoreTestCase.assertThat((Object)inputStream.read(data), (Matcher)CoreMatchers.equalTo((Object)length));
            ESBlobStoreTestCase.assertThat((Object)inputStream.read(), (Matcher)CoreMatchers.equalTo((Object)-1));
        }
        return data;
    }

    public static byte[] randomBytes(int length) {
        byte[] data = new byte[length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)ESBlobStoreTestCase.randomInt();
        }
        return data;
    }

    private static void writeBlob(BlobContainer container, String blobName, BytesArray bytesArray) throws IOException {
        try (StreamInput stream = bytesArray.streamInput();){
            container.writeBlob(blobName, (InputStream)stream, (long)bytesArray.length());
        }
    }

    protected abstract BlobStore newBlobStore() throws IOException;
}

