/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.script.AbstractSearchScript;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.LeafSearchScript;
import org.elasticsearch.script.ScoreAccessor;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptEngineService;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.lookup.LeafSearchLookup;
import org.elasticsearch.search.lookup.SearchLookup;

public class MockScriptEngine
implements ScriptEngineService {
    public static final String NAME = "mockscript";
    private final String type;
    private final Map<String, Function<Map<String, Object>, Object>> scripts;

    public MockScriptEngine(String type, Map<String, Function<Map<String, Object>, Object>> scripts) {
        this.type = type;
        this.scripts = Collections.unmodifiableMap(scripts);
    }

    public MockScriptEngine() {
        this(NAME, Collections.emptyMap());
    }

    public String getType() {
        return this.type;
    }

    public String getExtension() {
        return this.getType();
    }

    public Object compile(String name, String source, Map<String, String> params) {
        Function<Map<String, Object>, Object> script = this.scripts.get(source);
        if (script == null) {
            throw new IllegalArgumentException("No pre defined script matching [" + source + "] for script with name [" + name + "], did you declare the mocked script?");
        }
        return new MockCompiledScript(name, params, source, script);
    }

    public ExecutableScript executable(CompiledScript compiledScript, @Nullable Map<String, Object> vars) {
        MockCompiledScript compiled = (MockCompiledScript)compiledScript.compiled();
        return compiled.createExecutableScript(vars);
    }

    public SearchScript search(CompiledScript compiledScript, SearchLookup lookup, @Nullable Map<String, Object> vars) {
        MockCompiledScript compiled = (MockCompiledScript)compiledScript.compiled();
        return compiled.createSearchScript(vars, lookup);
    }

    public void close() throws IOException {
    }

    public boolean isInlineScriptEnabled() {
        return true;
    }

    public static Script mockInlineScript(String script) {
        return new Script(ScriptType.INLINE, "mock", script, Collections.emptyMap());
    }

    public class MockSearchScript
    implements SearchScript {
        private final Function<Map<String, Object>, Object> script;
        private final Map<String, Object> vars;
        private final SearchLookup lookup;

        public MockSearchScript(SearchLookup lookup, Map<String, Object> vars, Function<Map<String, Object>, Object> script) {
            this.lookup = lookup;
            this.vars = vars;
            this.script = script;
        }

        public LeafSearchScript getLeafSearchScript(LeafReaderContext context) throws IOException {
            LeafSearchLookup leafLookup = this.lookup.getLeafSearchLookup(context);
            final HashMap<String, Object> ctx = new HashMap<String, Object>(leafLookup.asMap());
            if (this.vars != null) {
                ctx.putAll(this.vars);
            }
            AbstractSearchScript leafSearchScript = new AbstractSearchScript(){

                public Object run() {
                    return MockSearchScript.this.script.apply(ctx);
                }

                public void setNextVar(String name, Object value) {
                    ctx.put(name, value);
                }

                public void setScorer(Scorer scorer) {
                    super.setScorer(scorer);
                    ctx.put("_score", new ScoreAccessor(scorer));
                }
            };
            leafSearchScript.setLookup(leafLookup);
            return leafSearchScript;
        }

        public boolean needsScores() {
            return true;
        }
    }

    public class MockExecutableScript
    implements ExecutableScript {
        private final Function<Map<String, Object>, Object> script;
        private final Map<String, Object> vars;

        public MockExecutableScript(Map<String, Object> vars, Function<Map<String, Object>, Object> script) {
            this.vars = vars;
            this.script = script;
        }

        public void setNextVar(String name, Object value) {
            this.vars.put(name, value);
        }

        public Object run() {
            return this.script.apply(this.vars);
        }
    }

    public class MockCompiledScript {
        private final String name;
        private final String source;
        private final Map<String, String> params;
        private final Function<Map<String, Object>, Object> script;

        public MockCompiledScript(String name, Map<String, String> params, String source, Function<Map<String, Object>, Object> script) {
            this.name = name;
            this.source = source;
            this.params = params;
            this.script = script;
        }

        public String getName() {
            return this.name;
        }

        public ExecutableScript createExecutableScript(Map<String, Object> vars) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            if (this.params != null) {
                context.putAll(this.params);
            }
            if (vars != null) {
                context.putAll(vars);
            }
            return new MockExecutableScript(context, this.script != null ? this.script : ctx -> new BytesArray(this.source));
        }

        public SearchScript createSearchScript(Map<String, Object> vars, SearchLookup lookup) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            if (this.params != null) {
                context.putAll(this.params);
            }
            if (vars != null) {
                context.putAll(vars);
            }
            return new MockSearchScript(lookup, context, this.script != null ? this.script : ctx -> this.source);
        }
    }
}

