/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.elasticsearch.Version;

public class VersionUtils {
    private static final List<Version> RELEASED_VERSIONS;
    private static final List<Version> UNRELEASED_VERSIONS;

    public static List<Version> allReleasedVersions() {
        return RELEASED_VERSIONS;
    }

    public static List<Version> allUnreleasedVersions() {
        return UNRELEASED_VERSIONS;
    }

    public static Version getPreviousVersion(Version version) {
        int index = RELEASED_VERSIONS.indexOf(version);
        assert (index > 0);
        return RELEASED_VERSIONS.get(index - 1);
    }

    public static Version getPreviousVersion() {
        Version version = VersionUtils.getPreviousVersion(Version.CURRENT);
        assert (version.before(Version.CURRENT));
        return version;
    }

    public static Version getPreviousMinorVersion() {
        Version version = Version.CURRENT;
        do {
            version = VersionUtils.getPreviousVersion(version);
            assert (version.before(Version.CURRENT));
        } while (version.minor == Version.CURRENT.minor);
        return version;
    }

    public static Version getFirstVersion() {
        return RELEASED_VERSIONS.get(0);
    }

    public static Version randomVersion(Random random) {
        return RELEASED_VERSIONS.get(random.nextInt(RELEASED_VERSIONS.size()));
    }

    public static Version randomVersionBetween(Random random, Version minVersion, Version maxVersion) {
        int minVersionIndex = 0;
        if (minVersion != null) {
            minVersionIndex = RELEASED_VERSIONS.indexOf(minVersion);
        }
        int maxVersionIndex = RELEASED_VERSIONS.size() - 1;
        if (maxVersion != null) {
            maxVersionIndex = RELEASED_VERSIONS.indexOf(maxVersion);
        }
        if (minVersionIndex == -1) {
            throw new IllegalArgumentException("minVersion [" + minVersion + "] does not exist.");
        }
        if (maxVersionIndex == -1) {
            throw new IllegalArgumentException("maxVersion [" + maxVersion + "] does not exist.");
        }
        if (minVersionIndex > maxVersionIndex) {
            throw new IllegalArgumentException("maxVersion [" + maxVersion + "] cannot be less than minVersion [" + minVersion + "]");
        }
        int range = maxVersionIndex + 1 - minVersionIndex;
        return RELEASED_VERSIONS.get(minVersionIndex + random.nextInt(range));
    }

    public static boolean isSnapshot(Version version) {
        return Version.CURRENT.equals((Object)version);
    }

    static {
        Field[] declaredFields = Version.class.getFields();
        HashSet<Integer> releasedIdsSet = new HashSet<Integer>();
        HashSet<Integer> unreleasedIdsSet = new HashSet<Integer>();
        for (Field field : declaredFields) {
            int id;
            int mod = field.getModifiers();
            if (!Modifier.isStatic(mod) || !Modifier.isFinal(mod) || !Modifier.isPublic(mod) || field.getType() != Version.class) continue;
            try {
                id = ((Version)field.get(null)).id;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            assert (field.getName().matches("(V(_\\d+)+(_(alpha|beta|rc)\\d+)?(_UNRELEASED)?|CURRENT)")) : field.getName();
            if (field.getName().equals("CURRENT") || field.getName().endsWith("UNRELEASED")) {
                unreleasedIdsSet.add(id);
                continue;
            }
            releasedIdsSet.add(id);
        }
        unreleasedIdsSet.remove(Version.CURRENT.id);
        releasedIdsSet.add(Version.CURRENT.id);
        assert (unreleasedIdsSet.stream().filter(releasedIdsSet::contains).collect(Collectors.toSet()).isEmpty());
        RELEASED_VERSIONS = Collections.unmodifiableList(releasedIdsSet.stream().sorted().map(Version::fromId).collect(Collectors.toList()));
        UNRELEASED_VERSIONS = Collections.unmodifiableList(unreleasedIdsSet.stream().sorted().map(Version::fromId).collect(Collectors.toList()));
    }
}

