/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.junit.listeners;

import com.carrotsearch.randomizedtesting.ReproduceErrorMessageBuilder;
import com.carrotsearch.randomizedtesting.SysGlobals;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.rest.yaml.ESClientYamlSuiteTestCase;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class ReproduceInfoPrinter
extends RunListener {
    protected final Logger logger = Loggers.getLogger(ESTestCase.class);

    public void testStarted(Description description) throws Exception {
        this.logger.trace("Test {} started", (Object)description.getDisplayName());
    }

    public void testFinished(Description description) throws Exception {
        this.logger.trace("Test {} finished", (Object)description.getDisplayName());
    }

    static boolean inVerifyPhase() {
        return Boolean.parseBoolean(System.getProperty("tests.verify.phase"));
    }

    public void testFailure(Failure failure) throws Exception {
        if (failure.getException() instanceof AssumptionViolatedException) {
            return;
        }
        StringBuilder b = new StringBuilder("REPRODUCE WITH: gradle ");
        String task = System.getProperty("tests.task");
        b.append(task);
        GradleMessageBuilder gradleMessageBuilder = new GradleMessageBuilder(b);
        gradleMessageBuilder.appendAllOpts(failure.getDescription());
        if (ESClientYamlSuiteTestCase.class.isAssignableFrom(failure.getDescription().getTestClass())) {
            gradleMessageBuilder.appendClientYamlSuiteProperties();
        }
        System.err.println(b.toString());
    }

    protected static class GradleMessageBuilder
    extends ReproduceErrorMessageBuilder {
        public GradleMessageBuilder(StringBuilder b) {
            super(b);
        }

        public ReproduceErrorMessageBuilder appendAllOpts(Description description) {
            super.appendAllOpts(description);
            if (description.getMethodName() != null) {
                super.appendOpt(SysGlobals.SYSPROP_TESTMETHOD(), "\"" + description.getMethodName() + "\"");
            }
            return this.appendESProperties();
        }

        public ReproduceErrorMessageBuilder appendEnvironmentSettings() {
            return this;
        }

        public ReproduceErrorMessageBuilder appendOpt(String sysPropName, String value) {
            if (sysPropName.equals(SysGlobals.SYSPROP_ITERATIONS())) {
                return this;
            }
            if (sysPropName.equals(SysGlobals.SYSPROP_TESTMETHOD())) {
                return this;
            }
            if (sysPropName.equals(SysGlobals.SYSPROP_PREFIX())) {
                return this;
            }
            if (Strings.hasLength((String)value)) {
                return super.appendOpt(sysPropName, value);
            }
            return this;
        }

        public ReproduceErrorMessageBuilder appendESProperties() {
            this.appendProperties("tests.es.logger.level");
            if (ReproduceInfoPrinter.inVerifyPhase()) {
                this.appendProperties("tests.cluster", "tests.enable_mock_modules");
            }
            this.appendProperties("tests.assertion.disabled", "tests.security.manager", "tests.nightly", "tests.jvms", "tests.client.ratio", "tests.heap.size", "tests.bwc", "tests.bwc.version");
            if (System.getProperty("tests.jvm.argline") != null && !System.getProperty("tests.jvm.argline").isEmpty()) {
                this.appendOpt("tests.jvm.argline", "\"" + System.getProperty("tests.jvm.argline") + "\"");
            }
            this.appendOpt("tests.locale", Locale.getDefault().toLanguageTag());
            this.appendOpt("tests.timezone", TimeZone.getDefault().getID());
            return this;
        }

        public ReproduceErrorMessageBuilder appendClientYamlSuiteProperties() {
            return this.appendProperties("tests.rest.suite", "tests.rest.blacklist");
        }

        protected ReproduceErrorMessageBuilder appendProperties(String ... properties) {
            for (String sysPropName : properties) {
                if (!Strings.hasLength((String)System.getProperty(sysPropName))) continue;
                this.appendOpt(sysPropName, System.getProperty(sysPropName));
            }
            return this;
        }
    }
}

