/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.CompositeReaderContext;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.Weight;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.lucene.index.ElasticsearchDirectoryReader;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.MockBigArrays;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.elasticsearch.index.cache.query.DisabledQueryCache;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.support.NestedScope;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.indices.fielddata.cache.IndicesFieldDataCache;
import org.elasticsearch.mock.orig.Mockito;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.fetch.FetchPhase;
import org.elasticsearch.search.fetch.subphase.DocValueFieldsFetchSubPhase;
import org.elasticsearch.search.fetch.subphase.FetchSourceSubPhase;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.IndexSettingsModule;
import org.mockito.Matchers;

public abstract class AggregatorTestCase
extends ESTestCase {
    private static final String NESTEDFIELD_PREFIX = "nested_";
    private List<Releasable> releasables = new ArrayList<Releasable>();

    protected <B extends AggregationBuilder> AggregatorFactory<?> createAggregatorFactory(B aggregationBuilder, IndexSearcher indexSearcher, MappedFieldType ... fieldTypes) throws IOException {
        IndexSettings indexSettings = new IndexSettings(IndexMetaData.builder((String)"_index").settings(Settings.builder().put("index.version.created", Version.CURRENT)).numberOfShards(1).numberOfReplicas(0).creationDate(System.currentTimeMillis()).build(), Settings.EMPTY);
        Engine.Searcher searcher = new Engine.Searcher("aggregator_test", indexSearcher);
        DisabledQueryCache queryCache = new DisabledQueryCache(indexSettings);
        QueryCachingPolicy queryCachingPolicy = new QueryCachingPolicy(){

            public void onUse(Query query) {
            }

            public boolean shouldCache(Query query) throws IOException {
                return false;
            }
        };
        ContextIndexSearcher contextIndexSearcher = new ContextIndexSearcher(searcher, (QueryCache)queryCache, queryCachingPolicy);
        NoneCircuitBreakerService circuitBreakerService = new NoneCircuitBreakerService();
        SearchContext searchContext = (SearchContext)org.mockito.Mockito.mock(SearchContext.class);
        org.mockito.Mockito.when((Object)searchContext.numberOfShards()).thenReturn((Object)1);
        org.mockito.Mockito.when((Object)searchContext.searcher()).thenReturn((Object)contextIndexSearcher);
        org.mockito.Mockito.when((Object)searchContext.bigArrays()).thenReturn((Object)new MockBigArrays(Settings.EMPTY, (CircuitBreakerService)circuitBreakerService));
        org.mockito.Mockito.when((Object)searchContext.fetchPhase()).thenReturn((Object)new FetchPhase(Arrays.asList(new FetchSourceSubPhase(), new DocValueFieldsFetchSubPhase())));
        org.mockito.Mockito.when((Object)searchContext.getObjectMapper(Matchers.anyString())).thenAnswer(invocation -> {
            String fieldName = (String)invocation.getArguments()[0];
            if (fieldName.startsWith(NESTEDFIELD_PREFIX)) {
                Mapper.BuilderContext context = new Mapper.BuilderContext(indexSettings.getSettings(), new ContentPath());
                return new ObjectMapper.Builder(fieldName).nested(ObjectMapper.Nested.newNested((boolean)false, (boolean)false)).build(context);
            }
            return null;
        });
        org.mockito.Mockito.when((Object)searchContext.bitsetFilterCache()).thenReturn((Object)new BitsetFilterCache(indexSettings, (BitsetFilterCache.Listener)org.mockito.Mockito.mock(BitsetFilterCache.Listener.class)));
        ((SearchContext)org.mockito.Mockito.doAnswer(invocation -> {
            this.releasables.add((Releasable)invocation.getArguments()[0]);
            return null;
        }).when((Object)searchContext)).addReleasable((Releasable)Matchers.anyObject(), (SearchContext.Lifetime)Matchers.anyObject());
        MapperService mapperService = this.mapperServiceMock();
        org.mockito.Mockito.when((Object)mapperService.getIndexSettings()).thenReturn((Object)indexSettings);
        org.mockito.Mockito.when((Object)mapperService.hasNested()).thenReturn((Object)false);
        org.mockito.Mockito.when((Object)searchContext.mapperService()).thenReturn((Object)mapperService);
        IndexFieldDataService ifds = new IndexFieldDataService(IndexSettingsModule.newIndexSettings("test", Settings.EMPTY, new Setting[0]), new IndicesFieldDataCache(Settings.EMPTY, new IndexFieldDataCache.Listener(){}), (CircuitBreakerService)circuitBreakerService, mapperService);
        org.mockito.Mockito.when((Object)searchContext.fieldData()).thenReturn((Object)ifds);
        SearchLookup searchLookup = new SearchLookup(mapperService, ifds, new String[]{"type"});
        org.mockito.Mockito.when((Object)searchContext.lookup()).thenReturn((Object)searchLookup);
        QueryShardContext queryShardContext = this.queryShardContextMock(mapperService, fieldTypes, (CircuitBreakerService)circuitBreakerService);
        org.mockito.Mockito.when((Object)searchContext.getQueryShardContext()).thenReturn((Object)queryShardContext);
        return aggregationBuilder.build(searchContext, null);
    }

    protected <A extends Aggregator, B extends AggregationBuilder> A createAggregator(B aggregationBuilder, IndexSearcher indexSearcher, MappedFieldType ... fieldTypes) throws IOException {
        AggregatorFactory<?> factory = this.createAggregatorFactory(aggregationBuilder, indexSearcher, fieldTypes);
        Aggregator aggregator = factory.create(null, true);
        return (A)aggregator;
    }

    protected MapperService mapperServiceMock() {
        return (MapperService)org.mockito.Mockito.mock(MapperService.class);
    }

    protected QueryShardContext queryShardContextMock(MapperService mapperService, MappedFieldType[] fieldTypes, CircuitBreakerService circuitBreakerService) {
        QueryShardContext queryShardContext = (QueryShardContext)org.mockito.Mockito.mock(QueryShardContext.class);
        org.mockito.Mockito.when((Object)queryShardContext.getMapperService()).thenReturn((Object)mapperService);
        for (MappedFieldType fieldType : fieldTypes) {
            org.mockito.Mockito.when((Object)queryShardContext.fieldMapper(fieldType.name())).thenReturn((Object)fieldType);
            org.mockito.Mockito.when((Object)queryShardContext.getForField(fieldType)).then(invocation -> fieldType.fielddataBuilder().build(mapperService.getIndexSettings(), fieldType, (IndexFieldDataCache)new IndexFieldDataCache.None(), circuitBreakerService, (MapperService)org.mockito.Mockito.mock(MapperService.class)));
        }
        NestedScope nestedScope = new NestedScope();
        org.mockito.Mockito.when((Object)queryShardContext.isFilter()).thenCallRealMethod();
        ((QueryShardContext)Mockito.doCallRealMethod().when((Object)queryShardContext)).setIsFilter(Matchers.anyBoolean());
        org.mockito.Mockito.when((Object)queryShardContext.nestedScope()).thenReturn((Object)nestedScope);
        return queryShardContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <A extends InternalAggregation, C extends Aggregator> A search(IndexSearcher searcher, Query query, AggregationBuilder builder, MappedFieldType ... fieldTypes) throws IOException {
        A a = this.createAggregator(builder, searcher, fieldTypes);
        try {
            InternalAggregation internalAgg;
            a.preCollection();
            searcher.search(query, a);
            a.postCollection();
            InternalAggregation internalAggregation = internalAgg = a.buildAggregation(0L);
            return (A)internalAggregation;
        }
        finally {
            Releasables.close(this.releasables);
            this.releasables.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <A extends InternalAggregation, C extends Aggregator> A searchAndReduce(IndexSearcher searcher, Query query, AggregationBuilder builder, MappedFieldType ... fieldTypes) throws IOException {
        ShardSearcher[] subSearchers;
        IndexReaderContext ctx = searcher.getTopReaderContext();
        if (ctx instanceof LeafReaderContext) {
            subSearchers = new ShardSearcher[]{new ShardSearcher((LeafReaderContext)ctx, ctx)};
        } else {
            CompositeReaderContext compCTX = (CompositeReaderContext)ctx;
            int size = compCTX.leaves().size();
            subSearchers = new ShardSearcher[size];
            for (int searcherIDX = 0; searcherIDX < subSearchers.length; ++searcherIDX) {
                LeafReaderContext leave = (LeafReaderContext)compCTX.leaves().get(searcherIDX);
                subSearchers[searcherIDX] = new ShardSearcher(leave, (IndexReaderContext)compCTX);
            }
        }
        ArrayList<InternalAggregation> aggs = new ArrayList<InternalAggregation>();
        Query rewritten = searcher.rewrite(query);
        Weight weight = searcher.createWeight(rewritten, true);
        A root = this.createAggregator(builder, searcher, fieldTypes);
        try {
            InternalAggregation internalAgg;
            for (ShardSearcher subSearcher : subSearchers) {
                A a = this.createAggregator(builder, subSearcher, fieldTypes);
                a.preCollection();
                subSearcher.search(weight, (Collector)a);
                a.postCollection();
                aggs.add(a.buildAggregation(0L));
            }
            if (aggs.isEmpty()) {
                ShardSearcher[] shardSearcherArray = null;
                return (A)shardSearcherArray;
            }
            if (AggregatorTestCase.randomBoolean()) {
                List internalAggregations = AggregatorTestCase.randomSubsetOf(AggregatorTestCase.randomIntBetween(1, aggs.size()), aggs);
                InternalAggregation internalAgg2 = ((InternalAggregation)aggs.get(0)).doReduce(internalAggregations, new InternalAggregation.ReduceContext(root.context().bigArrays(), null, false));
                aggs.removeAll(internalAggregations);
                aggs.add(internalAgg2);
            }
            InternalAggregation internalAggregation = internalAgg = ((InternalAggregation)aggs.get(0)).doReduce(aggs, new InternalAggregation.ReduceContext(root.context().bigArrays(), null, true));
            return (A)internalAggregation;
        }
        finally {
            Releasables.close(this.releasables);
            this.releasables.clear();
        }
    }

    protected static DirectoryReader wrap(DirectoryReader directoryReader) throws IOException {
        return ElasticsearchDirectoryReader.wrap((DirectoryReader)directoryReader, (ShardId)new ShardId(new Index("_index", "_na_"), 0));
    }

    private static class ShardSearcher
    extends IndexSearcher {
        private final List<LeafReaderContext> ctx;

        ShardSearcher(LeafReaderContext ctx, IndexReaderContext parent) {
            super(parent);
            this.ctx = Collections.singletonList(ctx);
        }

        public void search(Weight weight, Collector collector) throws IOException {
            this.search(this.ctx, weight, collector);
        }

        public String toString() {
            return "ShardSearcher(" + this.ctx.get(0) + ")";
        }
    }
}

