/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Response;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.test.rest.yaml.Stash;

public class ObjectPath {
    private final Object object;

    public static ObjectPath createFromResponse(Response response) throws IOException {
        byte[] bytes = EntityUtils.toByteArray((HttpEntity)response.getEntity());
        String contentType = response.getHeader("Content-Type");
        XContentType xContentType = XContentType.fromMediaTypeOrFormat((String)contentType);
        return ObjectPath.createFromXContent(xContentType.xContent(), (BytesReference)new BytesArray(bytes));
    }

    public static ObjectPath createFromXContent(XContent xContent, BytesReference input) throws IOException {
        try (XContentParser parser = xContent.createParser(NamedXContentRegistry.EMPTY, input);){
            if (parser.nextToken() == XContentParser.Token.START_ARRAY) {
                ObjectPath objectPath = new ObjectPath(parser.listOrderedMap());
                return objectPath;
            }
            ObjectPath objectPath = new ObjectPath(parser.mapOrdered());
            return objectPath;
        }
    }

    public ObjectPath(Object object) {
        this.object = object;
    }

    public Object evaluate(String path) throws IOException {
        return this.evaluate(path, Stash.EMPTY);
    }

    public Object evaluate(String path, Stash stash) throws IOException {
        String[] parts = this.parsePath(path);
        Object object = this.object;
        for (String part : parts) {
            if ((object = this.evaluate(part, object, stash)) != null) continue;
            return null;
        }
        return object;
    }

    private Object evaluate(String key, Object object, Stash stash) throws IOException {
        if (stash.containsStashedValue(key)) {
            key = stash.getValue(key).toString();
        }
        if (object instanceof Map) {
            return ((Map)object).get(key);
        }
        if (object instanceof List) {
            List list = (List)object;
            try {
                return list.get(Integer.valueOf(key));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("element was a list, but [" + key + "] was not numeric", e);
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException("element was a list with " + list.size() + " elements, but [" + key + "] was out of bounds", e);
            }
        }
        throw new IllegalArgumentException("no object found for [" + key + "] within object of class [" + object.getClass() + "]");
    }

    private String[] parsePath(String path) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean escape = false;
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '\\') {
                escape = true;
                continue;
            }
            if (c == '.') {
                if (escape) {
                    escape = false;
                } else {
                    if (current.length() <= 0) continue;
                    list.add(current.toString());
                    current.setLength(0);
                    continue;
                }
            }
            current.append(c);
        }
        if (current.length() > 0) {
            list.add(current.toString());
        }
        return list.toArray(new String[list.size()]);
    }
}

