/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml.section;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.xcontent.XContentLocation;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.test.rest.yaml.ClientYamlTestExecutionContext;
import org.elasticsearch.test.rest.yaml.section.ExecutableSection;

public class SetSection
implements ExecutableSection {
    private final Map<String, String> stash = new HashMap<String, String>();
    private final XContentLocation location;

    public static SetSection parse(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String currentFieldName = null;
        SetSection setSection = new SetSection(parser.getTokenLocation());
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (!token.isValue()) continue;
            setSection.addSet(currentFieldName, parser.text());
        }
        parser.nextToken();
        if (setSection.getStash().isEmpty()) {
            throw new ParsingException(setSection.location, "set section must set at least a value", new Object[0]);
        }
        return setSection;
    }

    public SetSection(XContentLocation location) {
        this.location = location;
    }

    public void addSet(String responseField, String stashedField) {
        this.stash.put(responseField, stashedField);
    }

    public Map<String, String> getStash() {
        return this.stash;
    }

    @Override
    public XContentLocation getLocation() {
        return this.location;
    }

    @Override
    public void execute(ClientYamlTestExecutionContext executionContext) throws IOException {
        for (Map.Entry<String, String> entry : this.stash.entrySet()) {
            Object actualValue = executionContext.response(entry.getKey());
            executionContext.stash().stashValue(entry.getValue(), actualValue);
        }
    }
}

